<?php
// cms/api/regions/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("order","offset","numofrec","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $order = determinateOrder(intval($_GET["order"]));
    $offset = $_GET["offset"];
    $numofrec = $_GET["numofrec"];
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 51))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //En caso de que el filter sea enviado, se construyes el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        
        // Iniciamos la cadena del query
        $filter = " AND ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            if($index == 0){
                $filter .= " regions.name LIKE '".$el."%' ".
                "           OR countries.name LIKE '".$el."%' ";
            }else{
                $filter .= " OR regions.name LIKE '".$el."%' ".
                "           OR countries.name LIKE '".$el."%' ";
            }
        }
        
        $filter .= " ) ";
        
    }
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(regions.id) AS qty".
    "       FROM regions, countries".
    "       WHERE regions.countryid = countries.id".
    "       ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los datos requeridos
    $sql = "SELECT regions.id AS regionsid, regions.name AS regionsname, ".
    "       regions.status AS regionsstatus, countries.name AS countriesname, ".
    "       countries.id AS countriesid".
    "       FROM regions, countries".
    "       WHERE regions.countryid = countries.id".
    "       ".$filter.
    "       ORDER BY ".$order.
    "       LIMIT ".$offset.",".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los datos
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["regionsid"];
        $record->dsc = $row["regionsname"];
        
        $record->country = new stdClass();
        $record->country->id = (int)$row["countriesid"];
        $record->country->dsc = $row["countriesname"];
        
        $record->status = new stdClass();
        $record->status->id = (int)$row["regionsstatus"];
        $record->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 48);
    $access->read =   tienePrivilegio($db, $sessionid, 51);
    $access->update = tienePrivilegio($db, $sessionid, 49);
    $access->delete = tienePrivilegio($db, $sessionid, 50);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   1 = Nombre de la region ASCENDENTE
    *   2 = Nombre del pais ASCENDENTE
    *   3 = Status de la region ASCENDENTE
    *   -1 = Nombre de la region DESCENDENTE
    *   -2 = Nombre del pais DESCENDENTE
    *   -3 = Status de la region DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    //COLOCAR EN APIARY 3/ -3 PARA STATUS
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = "regions.id DESC";
                break;
            case 1:
                $orderres = "regions.name ASC";
                break;
            case 2:
                $orderres = "countries.name ASC";
                break;
            case 3:
                $orderres = "regions.status ASC";
                break;
            case -1:
                $orderres = "regions.name DESC";
                break;
            case -2:
                $orderres = "countries.name DESC";
                break;
            case -3:
                $orderres = "regions.status DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 1, 2, -1 o -2"));
                break;
        }
        
        return $orderres;
    }
?>
