<?php
// api/paymentmethods/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    
    // Validamos la session
    isSessionValidAPI($db, $sessionid);
    
    // Consultamos la cantidad de registros(status = 1)
    $sql = "SELECT COUNT(paymentmethods.id) AS qty ".
    "       FROM paymentmethods, currencies ".
    "       WHERE paymentmethods.status = 1 ".
    "       AND paymentmethods.id > 0 ".
    "       AND paymentmethods.currencyid = currencies.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Retornamos el total
    $out->numofrecords = (int)$row["qty"];
    
    // Consultamos los detalles de los registros
    $sql = "SELECT paymentmethods.id AS methodid, ".
    "       paymentmethods.dsc AS methodname, ".
    "       currencies.id AS currencyid, ".
    "       currencies.symbol AS currencysymbol, ".
    "       currencies.name AS currencyname ".
    "       FROM paymentmethods, currencies ".
    "       WHERE paymentmethods.status = 1 ".
    "       AND paymentmethods.id > 0 ".
    "       AND paymentmethods.currencyid = currencies.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['methodid'];
        $record->dsc = $row['methodname'];
        
        $record->currency = new stdClass();
        $record->currency->id = (int)$row['currencyid'];
        $record->currency->dsc = $row['currencyname'];
        $record->currency->symbol = $row['currencysymbol'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
