<?php
// app/api/additional/ocupations

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Consultamos el total de registros
    $sql = "SELECT count(id) AS qty FROM ocupations";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Guardamos el total de registros
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos todos los registros
    $sql = "SELECT * FROM ocupations ORDER BY dsc";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        
        if($lang == "esp"){
            $record->dsc = $row["dsc"] == "" ? $row['dsc_eng'] : $row["dsc"];
        }else{
            $record->dsc = $row['dsc_eng'] == "" ?  $row['dsc'] :  $row['dsc_eng'];
        }
        
        $records [] = $record;
    }
    //Retornamos todos los registros
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
