<?php
// cms/api/messages/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('id',"sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    
    //Definimos las variables que usaremos y las inicializamos
    $out= new stdClass();
    $id = $_GET['id'];
    $sessionid = $_GET["sessionid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 73))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que el id exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM comunications ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Si existe, validamos que no se haya enviado
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM comunications ".
    "       WHERE id = ".$id.
    "       AND sentdate IS NOT NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    if($row['qty'] > 0){
        badEnd('344', array('msg'=>'Registro no puede ser eliminado'));
    }
    
    // Obtenemos los datos del mensaje para el audit
    $sql = "SELECT * ".
    "       FROM comunications ".
    "       WHERE id = ".$id.
    "       AND sentdate IS NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    // Eliminamos el registro
    $sql = "DELETE FROM comunications ".
    "       WHERE createddate = '".$row['createddate']."'".
    "       AND ref = '".$row['ref']."'";
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("402",array("msg"=>"Existen dependencias que no permiten eliminar este mensaje"));
        else
            badEnd("500",array("msg"=>$db->error));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "MENSAJERÍA", $sessionid, "CMS", "Se eliminó el mensaje ".$id);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
