<?php
// cms/api/preferences/saverates

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'currencies','rates');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $currencies = $_GET['currencies'];
    $rates = $_GET['rates'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Partimos los datos
    $currenciesarr = explode('-',$currencies);
    $ratesarr = explode('-',$rates);
    
    if(count($ratesarr) != count($currenciesarr)){
        badEnd('400',array('msg'=>'Parametros invalidos'));
    }
    
    //Recorremos los ids
    foreach($currenciesarr as $index => $currencyid){
        //Recorremos los rates
        foreach($ratesarr as $indextwo => $rate){
            
            // SI el indice coincide lo ingresamos
            if($index == $indextwo){
                //Consultamos el id para saber si existe
                $sql = "SELECT COUNT(currencyid) AS qty ".
                "       FROM cmsprefrates ".
                "       WHERE currencyid = ".$currencyid;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                        
                $row = $rs->fetch_assoc();
                    
                //SI es igual a 0 no existe
                if($row['qty'] == 0){
                    badEnd('204',array('msg'=>'Registro no encontrado'));
                }
                
                // Actualizamos el rate
                $sql = "UPDATE cmsprefrates SET ".
                "       rate = ".(validNumber($rate) ? floatval($rate) : (validNumberFormatted($rate) ? parseFormattedNumber($rate)  : '')).
                "       WHERE currencyid = ".$currencyid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                //COnsultamos el nombre de la moneda para mostrarlo en la auditoria
                $sql = "SELECT name FROM currencies WHERE id = ".$currencyid;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $row = $rs->fetch_assoc();
            
                //auditoria
                setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizó la tasa de la moneda ".$row['name']);   
            }
        }
    }
    
    $out->ids = $currencies;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
