WS_waitscreen = true;

window.onload = function(){
    
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
    // Window Load
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    
    // Go to Register Data Page
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','register-data',{ 'usr': document.getElementById('usr').textContent });
    }); 
    
    // Go to Register Confirm Page
    document.getElementById('next-button').addEventListener("click", function(){
        verif();
    }); 
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('number').value !== '' ){
            noError('number','ehash');
        }
    }); 
    
    // Resend verification code
    document.getElementById('resend').addEventListener("click", function(){
        resend();
    }); 
    
    // Enter
    document.getElementById('number').addEventListener('keydown', (event) => focusE(event, 'next-button'));
    
    setLang()

}

// Service users/activate
function verif(){
    var usr = document.getElementById('usr');
    var hash = document.getElementById('number');
    if ( hash.value === "" ){
        error('number','ehash',getLangById('usersactivate1')[lang]);
    } else{
        var req = {
            "usr": usr.textContent,
            "hash": hash.value
        }
        callWS("GET", "users/activate", req, response);
    
        function response(status, rsp){
            switch(status){
                case 200:
                    gotoPage('register','register-confirm','');
                    break;
                case 204:
                    document.getElementById('ehash').innerHTML = getLangById('usersactivate204')[lang];
                    break;
                case 401:
                    error('number','ehash',getLangById('usersactivate401')[lang]);
                    break;
                case 403:
                    document.getElementById('ehash').innerHTML = getLangById('usersactivate403')[lang];
                    break;
                case 406:
                    document.getElementById('ehash').innerHTML = getLangById('usersactivate406')[lang];
                    break;
                default:
                    document.getElementById('ehash').innerHTML = getLangById('usersactivatedefault')[lang];
                    break;
            }
        }    
    } 
}

function resend(){
    var usr = document.getElementById('usr');
    var req = {
        "usr": usr.textContent
    }
    callWS("GET", "users/insert", req, response);
    document.getElementById('waitScreen').style.display ="table";
    function response(status, rsp){
            switch(status){
                case 200:
                    document.getElementById('ehash').innerHTML = getLangById('usersinsert200')[lang];
                    break;
                case 401:
                    error('number','ehash',getLangById('usersinsert401')[lang]);
                    break;
                case 409:
                    document.getElementById('ehash').innerHTML = getLangById('usersinsert409')[lang];
                    break;
                default:
                    document.getElementById('ehash').innerHTML = getLangById('usersinsertdefault')[lang];
                    break;
            }
            document.getElementById('waitScreen').style.display ="none";
        }   
    
}

function setLang(){
    
    lang = lang = localStorage.getItem('lang') ? lang = localStorage.getItem('lang') : 'esp';
    
    /* inner HTML */
    setWordLanginnerHTML('register','register');
    setWordLanginnerHTML('register1','register1');
    setWordLanginnerHTML('register2','register2');
    setWordLanginnerHTML('register3','register3');
    setWordLanginnerHTML('register4','register4');
    setWordLanginnerHTML('registerTitle','register3');
    setWordLanginnerHTML('principaltext','principaltext');
    setWordLanginnerHTML('secondarytext','secondarytext');
    setWordLanginnerHTML('resend','resend');
    setWordLanginnerHTML('previous-button','previous');
    setWordLanginnerHTML('next-button','validate');
    setWordLanginnerHTML('ts','ts');
    
    //Mostrar HTML cargado
    esconderHTML(false);   
}