<?php
// cms/api/users/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","name","email","status","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $name = $_GET["name"];
    $email = $_GET["email"];
    $status = $_GET["status"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    // Si se envio un rolid, lo consultamos para validar que exista
    if(validateUpdate("rolid")){
        $sql = "SELECT name, status FROM cmsusers WHERE id = ".$_GET["rolid"]." AND type = 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro(rol)"));
        }
    }
    
    //Si el id es igual a 0, se crea, si no se actualiza la moneda
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 15))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "INSERT INTO cmsusers(usr, name, status, datecreated, type, rolid)".
        "       VALUES ('".$email."', '".$name."', ".$status.", NOW(), 0".validateInsertRol('rolid').")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        // Si se envio un rolid, le incluimos al usuarios los privilegios
        if(validateUpdate("rolid")){
            $sql =  "DELETE FROM userprivileges ".
            "       WHERE userid = '".$out->id."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $sql =  "INSERT INTO userprivileges ".
            "       (userid, privilegeid) ".
            "       SELECT '".$out->id."', privilegeid ".
            "       FROM userprivileges ".
            "       WHERE userid = ".$_GET["rolid"];
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }
        
        //auditoria
        setAudit($db, "USUARIOS", $sessionid, "CMS", "Se agregó el usuario ".$name);
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 16))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT name, status, rolid FROM cmsusers WHERE id = ".$id." AND type = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro(usuario)"));
        }
        
        $oldrol = $row["rolid"];
        
        // Si se envio un rolid, le incluimos al usuarios los privilegios
        if(validateUpdate("rolid")){
            if ($_GET["rolid"] != $oldrol){
                $sql =  "DELETE FROM userprivileges ".
                "       WHERE userid = '".$id."'";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $sql =  "INSERT INTO userprivileges ".
                "       (userid, privilegeid) ".
                "       SELECT '".$id."', privilegeid ".
                "       FROM userprivileges ".
                "       WHERE userid = ".$_GET["rolid"];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }
        }else{
            //Si no, eliminamos en caso de que tenga
            $sql =  "DELETE FROM userprivileges ".
            "       WHERE userid = '".$id."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }
        
        //Actualizamos el usuario
        $sql = "UPDATE cmsusers SET".
        "       usr = '".$email."', ".
        "       name = '".$name."', ".
        "       ".(validateUpdate("rolid") ? " rolid = ".$_GET["rolid"].", " : " rolid = 0,").
        "       status = ".$status." ".
        "       WHERE id = ".$id." AND type = 0";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "USUARIOS", $sessionid, "CMS", "Se actualizó el usuario ".$name);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*Funcion valida la existencia del campo para asi ingresarlo a la base de datos, en esta se recibe un parametro
    * $field == Es el campo que se estara evaluando.
    */
    function validateInsertRol($field){
        $strInsert = "";
        
        if(isset($_GET[$field]) && $_GET[$field] != ""){
            $strInsert .= ", ".$_GET[$field]."";
        }else{
            $strInsert .= ", 0";
        }
        
        return $strInsert;
    }
    
    /* Funcion para validar que el parametro fue enviado.
    * Si el parametro existe retorna true y si no retorna false
    */
    function validateUpdate($param){
        $bolValues = false;
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $bolValues = true;
        }
        return $bolValues;
    }
?>
