<?php
// pay/api/queries/balance
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
        
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $refcurr = '-1';
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValidPAY($db, $sessionid);
    
    // En caso de que el refcurr sea enviado, se construye el query
    if (isset($_GET['refcurr']) && $_GET['refcurr'] != '') {
        $refcurr = $_GET['refcurr'];
        // Obtenemos los decimales y el simbolo de la moneda
        $sql = "SELECT decimals,symbol FROM currencies WHERE id = ".$refcurr;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        $row = $rs->fetch_assoc();
        //#new
        $refdecim = $row['decimals'];
        $refsym = $row['symbol'];
    } else {
        // Obtenemos la moneda de referencia (SE OBTIENE ID SE FILTR POR PAYREF)
        $sql = "SELECT id,decimals,symbol FROM currencies WHERE payref = 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        $refcurr = $row['id'];
        //#new
        $refdecim = $row['decimals'];
        $refsym = $row['symbol'];
    }
    
    //Consultamos las monedas
    $sql = "SELECT curr.id AS currencyid,".
    "       curr.name AS currencyname, ".
    "       curr.symbol AS currencysymbol, ".
    "       curr.decimals AS currencydecimals, ".
    "       curr.status AS currencystatus, ".
    "       curr.interface AS currencyinterface, ".
    "       curr.status AS currstatus, ".
    "       curr.icon AS icon, ".
    "       curr.xfer AS currencyxfer, ".//agregado
    "       acc.id AS accountid, ".
    "       acc.status AS accountstatus, ".
    "       IF(acc.id IS NULL, 0, ( ".
    "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id AND paypending = 0) - ".
    "           ABS(IF(( ".
    "               SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "               FROM orders ".
    "               WHERE orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"               AND orders.type != 1) IS NOT NULL,  ".
	"                   ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = acc.id".
    "           AND orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"               AND transactions.amount < 0 ".
	"               AND orders.type != 1) IS NOT NULL, ( ".
    "               SELECT SUM(transactions.amount) AS amount ".
    "            FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND transactions.accountid = acc.id".
    "               AND orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"                AND transactions.amount < 0 ".
	"                AND orders.type != 1),0) ".
	"           + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"                FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"               (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"               FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"           )".
    "       )) AS avaliable ".
    "       FROM currencies curr ".
    "       LEFT JOIN accounts acc ON ".
    "           acc.currencyid = curr.id ".
    "           AND acc.userid = ".$userid.
    "           AND acc.paymentmethodid = -1 ".
    "           AND acc.entityusrid = ".$entityid.
    "       WHERE (curr.status = 1 ".
    "       OR IF(acc.id IS NULL, 0, ( ".
    "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id  AND paypending = 0) - ".
    "           ABS(IF(( ".
    "               SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "               FROM orders ".
    "               WHERE orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"               AND orders.type != 1) IS NOT NULL,  ".
	"                   ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = acc.id".
    "           AND orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"               AND transactions.amount < 0 ".
	"               AND orders.type != 1) IS NOT NULL, ( ".
    "               SELECT SUM(transactions.amount) AS amount ".
    "            FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND transactions.accountid = acc.id".
    "               AND orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"                AND transactions.amount < 0 ".
	"                AND orders.type != 1),0) ".
	"           + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"                FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"               (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"               FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"           )".
    "       )) > 0 )".
    "       AND curr.id > 0 ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
   
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['currencydecimals'];
        $record->status = (int)$row['currstatus'];

        $record->reference = new stdClass();
        
        $record->reference->decimals = $refdecim; 
        $record->reference->symbol = $refsym; 
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";

        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $record->icon = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $row['icon']) {
                    $record->icon = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $record->icon = null;
        }
        
        $record->rate = new stdClass();
        $record->rate = determinateRatePairs($db, $record->id, $refcurr, $record->decimals);
        
        if($row['accountid'] != NULL){
            //Balance a partir de las transacciones
            
            $record->balance = new stdClass();
            
            $record->balance->number = (float)bcdiv(number_format($row['avaliable'],13, '.', ''), '1',$row["currencydecimals"]);
            $record->balance->number = $record->balance->number < 0 ? 0 : $record->balance->number;
            $record->balance->formatted = numberFormatt($record->balance->number,$row["currencydecimals"]);
        }else{
            $record->balance = new stdClass();
            $record->balance->number = 0;
            $record->balance->formatted = numberFormatt($record->balance->number,$row["currencydecimals"]);
        }
        
        // Obtenemos los pares donde esta la moneda
        $sql = "SELECT COUNT(pairs.id) AS qty ".
        "       FROM pairs ".
        "       WHERE ".
        "       (currencyid = ".$record->id.
        "       OR refcurrencyid = ".$record->id." )".
        "       AND status = 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $pairres = $res->fetch_assoc();
        
        //Si existe el par directo hacemos la conversion de balance
        $pairscurrencies = [];
        if($pairres['qty'] > 0){
            $sql = "SELECT * ".
            "       FROM pairs ".
            "       WHERE ".
            "       (currencyid = ".$record->id.
            "       OR refcurrencyid = ".$record->id." )".
            "       AND status = 1";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            while($pairres = $res->fetch_assoc()){
                $paircurr = new stdClass();
                
                if ($pairres['currencyid'] == $record->id) {
                    // Buscamos por el ref
                    $sql = "SELECT id, name, symbol, decimals, icon ".
                    "       FROM currencies".
                    "       WHERE id = ".$pairres['refcurrencyid'];
                } else {
                    // Buscamos por el base
                    $sql = "SELECT id, name, symbol, decimals, icon ".
                    "       FROM currencies".
                    "       WHERE id = ".$pairres['currencyid'];
                }
                
                if (!$resCur=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                
                $resCur = $resCur->fetch_assoc();
                
                if ($pairres['currencyid'] == $record->id) {
                    // Buscamos por el ref
                    $paircurr->pair = $resCur['symbol'].'/'.$record->symbol;
                } else {
                    // Buscamos por el base
                    $paircurr->pair = $record->symbol.'/'.$resCur['symbol'];
                }

                $paircurr->id = (int)$resCur['id'];
                $paircurr->name = $resCur['name'];
                $paircurr->symbol = $resCur['symbol'];
                $paircurr->decimals = (int)$resCur['decimals'];
                
                
                // Validamos que el file exista
                $urljson = "../../icons/icons.json";
        
                if(file_exists($urljson)){
                    // SI existe obtenemos el json
                    $json = json_decode(file_get_contents($urljson), true);
                    $paircurr->icon = null;
                    foreach($json['icons'] as $icon){
                        if ($icon['name'] == $resCur['icon']) {
                            $paircurr->icon = $homeurlpay."icons/".$icon['url'];
                        }
                    }
                }else{
                    $paircurr->icon = null;
                }
                
                //Obtenemos la ultima transaccion realizada
                $sql = "SELECT (SELECT ord.price FROM orders ord ".
                "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS lastprice ".
                "       FROM orders, accounts, transactions t  ".
                "           LEFT JOIN transactions txother ".
                "               ON t.orderid != txother.orderid ".
                "               AND t.txid = txother.txid  ".
                "               AND txother.amount > 0 ".
                "               AND txother.dsc NOT LIKE 'Comisi%' ".
                "       WHERE t.orderid IS NOT NULL ".
                "       AND orders.id = txother.orderid ".
                "       AND orders.pairid = ".$pairres['id'].
                "       AND t.id = t.txid ".
                "       AND t.dsc NOT LIKE 'Comisi%' ".
                "       AND accounts.id = orders.accountid ".
                "       GROUP BY t.txid ".
                "       ORDER BY t.datecreated DESC, t.id DESC".
                "       LIMIT 1";
                if (!$resLast=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $row = $resLast->fetch_assoc();
                
                $paircurr->rate = new stdClass();
                $paircurr->rate->number = (float)number_format($row["lastprice"], $pairres['currencyid'] != $record->id ? $paircurr->decimals : $record->decimals, '.','');
                $paircurr->rate->formatted = number_format($paircurr->rate->number, $pairres['currencyid'] != $record->id ? $paircurr->decimals : $record->decimals,",",".");
                
                $pairscurrencies [] = $paircurr;
            }
            
            $record->targetpairs = $pairscurrencies;
        }
        
        $records [] = $record;
    }
    
    $out->currencies = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>