<?php
//pay/api/receivepayment/cancel
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('txid');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $txid = $_GET['txid'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Validamos que exista el movimiento
    $sql = "SELECT COUNT(id) AS qty FROM transactions WHERE txid = ".$txid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        badEnd("404", array("msg"=>"Cobro no encontrado"));
    }
    
    $db->autocommit(FALSE);
    
    // Eliminamos el cobro   
    $sql = "DELETE FROM transactions WHERE txid = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este cobro"));
        else
            badEnd("500",array("msg"=>$error));
    }
    
    // Eliminamos la informacion de cobro  
    $sql = "DELETE FROM paytxdetails WHERE transactionid = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este cobro"));
        else
            badEnd("500",array("msg"=>$error));
    }
    
    $db->commit();
    $db->autocommit(TRUE);
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    // Auditoria
    setAuditPAY($db, "OPERACIONES", $sessionid, "APP", "Se canceló el cobro #".$txid." creado por ".$userdataaudit['name'], $ipaddress);
    
    $db->close();
    
    $out->deletedid = $txid;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>