<?php
//pay/api/receivepayment/check
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('txid');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $txid = $_GET['txid'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Validamos que exista el movimiento
    $sql = "SELECT COUNT(id) AS qty FROM transactions WHERE txid = ".$txid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        badEnd("404", array("msg"=>"Cobro no encontrado"));
    }
    
    $sql = "SELECT * FROM transactions WHERE id = ".$txid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->paid = $row['paypending'] == 1 ? false : true;
    $out->payer = new stdClass();
    
    if ($out->paid) {
        
        // Obtenemos los datos del pago
        $sql = "SELECT transactions.id AS txid, ".
        "       ABS(transactions.amount) AS amount, ".
        "       currencies.name AS currencyname, ".
        "       currencies.decimals AS decimals, ".
        "       currencies.symbol AS symbol, ".
        "       currencies.id AS currencyid, ".
        "       currencies.icon AS icon, ".
        "       payusers.userid AS userid, ".
        "       payusers.avatarimgtype AS avatartype, ".
        "       IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
        "       FROM accounts, currencies, transactions, payusers ".
        "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
        "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
        "       WHERE transactions.txid = ".$txid.
        "       AND transactions.dsc LIKE '%Pago PAY%' ".
        "       AND transactions.accountid = accounts.id ".
        "       AND accounts.currencyid = currencies.id ".
        "       AND accounts.userid = payusers.userid ".
        "       AND transactions.id != ".$txid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        $out->payer->name = $row['name'];
        
        if ($row['avatartype'] != null) {
            $out->payer->avatar = new stdClass();
            //Buscamos el archivo para obtener su nombre y extension
            $filestest = glob("../../../uploads/users/".$row['userid']."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
            
            //El primer resultado
            $info = pathinfo($filestest[0]);
            
            if($info['basename'] != ""){
                $out->payer->avatar = new stdClass();
                $out->payer->avatar->type = $row['avatartype'];
                $out->payer->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
            }else{
                $out->payer->avatar = null;
            }
        } else {
            $out->payer->avatar = null;
        }
        
        $out->payer->amount = new stdClass();
        $out->payer->amount->number = (float)bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
        $out->payer->amount->formatted = number_format($out->payer->amount->number,$row['decimals'], ',', '.');
        
        $out->payer->currency = new stdClass();
        $out->payer->currency->id = (int)$row['currencyid'];
        $out->payer->currency->name = $row['currencyname'];
        $out->payer->currency->symbol = $row['symbol'];
        $out->payer->currency->decimals = (int)$row['decimals'];
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";
        
        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $out->payer->currency->icon = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $row['icon']) {
                    $out->payer->currency->icon = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $out->payer->currency->icon = null;
        }
    
    } else {
        $out->payer = null;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>