<?php
//pay/api/receivepayment/external
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('txid', 'currencyid');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    
    $currencyid = $_GET['currencyid'];
    $transactionid = $_GET['txid'];
    $externalphone = '';
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Si obtenemos el parametro externalphone, lo guardamos
    if (isset($_GET['externalphone']) && $_GET['externalphone'] != '') {
        $externalphone = $_GET['externalphone'];
    }
    
    generateAccountsByCurrencyId($db, $currencyid, $userid);
    
    // Obtenemos el id de la transaccion por el TXID
    $sql = "SELECT deposits.transactionid AS transactionid ".
    "       FROM deposits ".
    "       WHERE deposits.paymentref LIKE '%".$transactionid."%'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $deposits = $rs->fetch_assoc();
    
    if ($deposits['transactionid'] == null) {
        badEnd("404", array("msg"=>'Movimiento '.$transactionid." no encontrado"));
    }
    
    $transactionid = $deposits['transactionid'];
    
    //Consultamos la moneda para hacer llamado a API
    $sql = "SELECT currencies.symbol AS symbol, ".
    "       currencies.name AS name, ".
    "       currencies.id AS id, ".
    "       currencies.interface AS interface, ".
    "       currencies.decimals AS decimals, ".
    "       ABS(transactions.amountghost) AS amount ".
    "       FROM currencies, accounts, transactions ".
    "       WHERE transactions.id = ".$transactionid.
    "       AND accounts.currencyid = ".$currencyid.
    "       AND transactions.accountid = accounts.id ".
    "       AND accounts.currencyid = currencies.id ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencydata = $rs->fetch_assoc();
    
    $out->txid = (int)$transactionid;
    
    $out->currency = new stdClass();
    $out->currency->id = (int)$currencydata['id'];
    $out->currency->name = $currencydata['name'];
    $out->currency->symbol = $currencydata['symbol'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    //$record->basecurrency->test = $pairrefdata['icon'];
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $currtx['icon']) {
                $out->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->currency->icon = null;
    }
    
    //Consultamos la transaccion requerida
    $sql = "SELECT transactions.id AS txid, ".
    "       transactions.txid AS txref, ".
    "       transactions.datecreated AS createddate, ".
    "       transactions.dsc AS dsc, ".
    "       (transactions.amount + transactions.amountghost) AS amount, ".
    "       transactions.accountorigin AS accountorigin, ".
    "       transactions.accountdestination AS accountdestination, ".
    "       transactions.accountid AS txaccountid, ".
    "       currencies.id AS currencyid, ".
    "       currencies.decimals AS decimals, ".
    "       deposits.valid AS valid, ".
    "       deposits.paymentdate AS paymentdate, ".
    "       deposits.filetype AS filetype, ".
    "       deposits.payvalid AS payvalid, ".
    "       deposits.paymentref AS ref ".
    "       FROM accounts, currencies, transactions  ".
    "       LEFT JOIN deposits ON transactions.id = deposits.transactionid".
    "       LEFT JOIN withdrawals ON transactions.id = withdrawals.transactionid".
    "       LEFT JOIN paytxdetails ON paytxdetails.transactionid = transactions.id ".
    "       WHERE transactions.id = ".$transactionid.
    "       AND transactions.accountid = accounts.id".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = ".$currencyid.
    "       AND accounts.currencyid = currencies.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
        
    $row = $rs->fetch_assoc();
    
    if ($row['txid'] == null) {
        badEnd("404", array("msg"=>"Movimiento no encontrado"));
    }
    
    $out->validated = $row['payvalid'] == null ? false : true;
    
    $out->amount = new stdClass();
    $out->amount->number = 0;
    
    $out->fee = new stdClass();
    $out->fee->number = 0;
    
    //Si es 0 no es comision, 1 es una comision
    $isFee = 0;
    
    //Si tiene la palabra comision retorna 1
    if(stripos($row["dsc"], "comisión") !== false){
        $isFee = 1;
    }
    
    if($isFee == 1){
        $sql = "SELECT (transactions.amount + transactions.amountghost) AS amount ".
        "       FROM transactions, accounts ".
        "       WHERE transactions.id = ".$row["txref"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
        
        $amountdata = $res->fetch_assoc();
        
        //Monto del movimiento
        $out->amount->number = bcdiv(number_format($amountdata['amount'],13, '.', ''), '1',$row['decimals']);
    }else{
        //Monto del movimiento
        $out->amount->number = bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
    }
    
    $out->amount->formatted = number_format($out->amount->number,$row['decimals'], ',', '.');
    
    if($isFee == 1){
        $out->fee->number = bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
    }else{
        //Fee del movimiento
        $sql = "SELECT (transactions.amount + transactions.amountghost) AS amount ".
        "       FROM transactions, accounts ".
        "       WHERE transactions.txid = ".$transactionid.
        "       AND transactions.dsc LIKE '%Comision%'".
        "       AND transactions.accountid = accounts.id".
        "       AND accounts.currencyid = ".$currencyid.
        "       AND accounts.paymentmethodid = -1".
        "       AND accounts.currencyid = ".$row['currencyid'];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
            
        $feedata = $res->fetch_assoc();
        
        $out->fee->number = bcdiv(number_format($feedata["amount"],13, '.', ''), '1',$row['decimals']);
    }
    
    $out->fee->formatted = number_format($out->fee->number,$row['decimals'], ',', '.');
    
    if (!$out->validated) {
        // Actualizamos el status en la tabla deposits
        $sql = "UPDATE deposits SET ".
        "       payvalid = NOW() ".
        "       WHERE transactionid = ".$transactionid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
            
        // Actualizamos el telefono si se envio
        if ($externalphone != '') {
            $sql = "INSERT INTO externalpayers(txid, phone, datecreated) ".
            "       VALUES(".$transactionid.", '".$externalphone."', NOW())";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
?>