<?php
//pay/api/receivepayment/prepare
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('currency');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $currencyid = $_POST['currency'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //  Obtenemos el nivel del usuario
    $sql = "SELECT level FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    $level = $row['level'];
    
    // Validamos que la moneda exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();

    if($row['qty'] == 0){
        badEnd("402", array("msg"=>"Moneda no encontrada"));
    }
    
    generateAccountsByCurrencyId($db, $currencyid, $userid);
    
    //  Obtenemos las monedas que tiene el usuario para enviar
    $sql = "SELECT receivecurrencies ".
    "       FROM payusers ".
    "       WHERE userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    $receivecurrencies = explode(',', $row['receivecurrencies']);
    // Validamos si existe la moneda en su configuracion de recibir
    foreach($receivecurrencies as $currency){//Se Crean las cuentas en todas las monedas que se quiera recibir y que falten
        generateAccountsByCurrencyId($db, $currency, $userid);
    }
        
    //Consultamos las monedas
    $sql = "SELECT curr.id AS currencyid,".
    "       curr.name AS currencyname, ".
    "       curr.symbol AS currencysymbol, ".
    "       curr.decimals AS currencydecimals, ".
    "       curr.status AS currencystatus, ".
    "       curr.interface AS currencyinterface, ".
    "       acc.id AS accountid, ".
    "       acc.paymentmethodid AS paymentmethodid, ".
    "       acc.status AS accountstatus, ".
    "       ws.wallet AS wallet, ". //Incluido
    "       IF(acc.id IS NULL, 0, ( ".
    "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id AND paypending = 0) - ".
    "           ABS(IF(( ".
    "               SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "               FROM orders ".
    "               WHERE orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"               AND orders.type != 1) IS NOT NULL,  ".
	"                   ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = acc.id".
    "           AND orders.accountid = acc.id".
	"           AND orders.canceled IS NULL ".
	"               AND transactions.amount < 0 ".
	"               AND orders.type != 1) IS NOT NULL, ( ".
    "               SELECT SUM(transactions.amount) AS amount ".
    "            FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND transactions.accountid = acc.id".
    "               AND orders.accountid = acc.id".
	"               AND orders.canceled IS NULL ".
	"                AND transactions.amount < 0 ".
	"                AND orders.type != 1),0) ".
	"           + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"                FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"               (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"               FROM transactions  ".
	"               WHERE transactions.paypending = 1".
	"               AND transactions.accountid = acc.id".
	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"           )".
    "       )) AS avaliable ".
    "       FROM currencies curr ".
    "       LEFT JOIN accounts acc ON ".
    "           acc.currencyid = curr.id ".
    "           AND acc.userid = ".$userid.
    "           AND acc.entityusrid = ".$entityid.
    "           AND acc.paymentmethodid = -1 ".
    /*Se agrega la wallet*/
    "           LEFT JOIN (".
	"               SELECT MAX(tb2.id) AS id, accountid AS accid FROM wallets tb2 GROUP BY tb2.accountid".
    "           ) maxwall ON".//Wallets mas recientes agrupada por cuenta con las cuentas acc.id
    "           acc.id = maxwall.accid".
    "           LEFT JOIN wallets ws ON ws.id = maxwall.id ".//Información de las wallets recientes
    "           WHERE curr.status = 1 ".
    "           AND curr.id > 0 ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();

        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['currencydecimals'];
        $record->receive = false;
        
        // Validamos si existe la moneda en su configuracion de envio
        foreach($receivecurrencies as $currency){
            if($currency == $record->id){
                $record->receive = true;
            }
        }
        
        $record->rate = determinateRate($db, $currencyid, $record->id, $record->decimals);

        $account = new stdClass();
        $account->id = (int)$row["accountid"];
        $account->wallet = nvl($row["wallet"],'');
        // Obtenemos la wallet, el servicio sigue explotando si se tiene una moneda sin cuenta OJO al $row["accountid"] vacío
        //Ajustada esta sección para devolver la wallet en query principal de monedas con cuentas
        /*
        if($account->id){
            $sql = "SELECT * ".
            "       FROM wallets ".
            "       WHERE accountid = ".$row["accountid"]." ORDER BY id DESC LIMIT 1";//Traer la wallet más reciente
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $wallet = $res->fetch_assoc();
            
            if ($wallet['wallet'] != NULL) {
                $account->wallet = $wallet['wallet'];
            } else {
                $account->wallet = '';
            }
        }*/
        //Balance a partir de las transacciones
        $account->balance = new stdClass();
        
        $account->balance->number = $row['avaliable'] == null ? 0 : (float)bcdiv(number_format($row['avaliable'],13, '.', ''), '1',$row["currencydecimals"]);
        $account->balance->number = $account->balance->number < 0 ? 0 : $account->balance->number;
        $account->balance->formatted = numberFormatt($account->balance->number,$row["currencydecimals"]);
        
        $record->account = $account;
        
        $sql = "SELECT maxamountmonthlyopxfer AS maxxfer, ".
        "       maxamountopsendpay AS maxmoneysendamount ".
        "       FROM cmspreffees ".
        "       WHERE levelid = ".$level.
        "       AND currencyid = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $maxes = $res->fetch_assoc();
        
        $record->maxs = new stdClass();
        
        // Obtenemos la configuracion del envio de dinero
        $record->maxs->moneysend = new stdClass();
        $record->maxs->moneysend->amount = new stdClass();
        $record->maxs->moneysend->amount->number = (float)number_format($maxes['maxmoneysendamount'], $record->decimals, '.', '');
        $record->maxs->moneysend->amount->formatted = numberFormatt($record->maxs->moneysend->amount->number, $record->decimals);
        
        // Obtenemos la configuracion de las transferencias
        $record->maxs->xfer = new stdClass();
        $record->maxs->xfer->amount = new stdClass();
        $record->maxs->xfer->amount->number = (float)number_format($maxes['maxxfer'], $record->decimals, '.', '');
        $record->maxs->xfer->amount->formatted = numberFormatt($record->maxs->xfer->amount->number, $record->decimals);
        
        $records [] = $record;
    }
    
    $out->currencies = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>