<?php
//pay/api/sendmoney/executepagomovil
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    
    date_default_timezone_set('Etc/UTC');
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('secretcode');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $secretcode = $_POST['secretcode'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer operaciones
    isLevelValid($db, $userid);
    
    // Buscamos si hay una transaccion con ese codigo
    //Consultamos los datos de la transaccion
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("402", array("msg"=>"Código invalido"));
    }
    
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("403", array("msg"=>"Código expirado"));
    }
    
    // Si llegamos aqui, buscamos la info de ese tx
    $sql = "SELECT txid, id, accountid ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    $id = $txdata['txid'];
    
    // Buscamos la cuenta del usuario
    $sql = "SELECT txid, id, accountid ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode.
    "       AND transactions.id = transactions.txid".
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $txaccountdata = $rs->fetch_assoc();
    
    $accountid = $txaccountdata['accountid'];
    
    // Buscamos los datos del pago movil
    $sql = "SELECT * ".
    "       FROM pagomovildetails ".
    "       WHERE transactionid = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $pagomovildata = $rs->fetch_assoc();
    
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = ".$pagomovildata['currencytx'];
     if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $currency = $rs->fetch_assoc();
    
    // Sacamos la moneda de la cuenta
    $sql = "SELECT currencies.* ".
    "       FROM accounts ".
    "       INNER JOIN currencies ON currencies.id = accounts.currencyid ".
    "       WHERE accounts.id = ".$accountid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $currencyaccount = $res->fetch_assoc();
    
    // Obtenemos los datos del BS
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencyfiat = $rs->fetch_assoc();
    
    // Consultamos de la vista ya creada con el balance
    $sql = "SELECT * FROM accountbalances WHERE accountid = ".$accountid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $balancetx = $res->fetch_assoc();
    
    $rate1 = determinateRate($db, $currencyfiat["id"], $currencyaccount['id'], $currencyfiat['decimals']); //se volteó las monedas y se cambiaron los decimals 
    $amountReal = number_format($pagomovildata['amounttx']*$rate1->number, $currencyaccount['decimals'], '.', '');
    
    if(
        number_format($balancetx["balance"], $currencyaccount['decimals'], '.', '') <= 0 ||
        number_format($balancetx["balance"], $currencyaccount['decimals'], '.', '') < number_format($amountReal, $currencyaccount['decimals'], '.', '')
    ){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    // Obtenemos la interfaz del banco
    $bankinterface = getActiveBank($db, 2, 1);
    
    // Inicializamos la referencia
    $reference = '';
    
    $db->autocommit(FALSE);
    
    // Traemos el listado de los bancos
    switch($bankinterface){
        case 0:
            badEnd("204", array("msg"=>determinateMsgFail(array(
                "esp"=>'Servicio inactivo, intente más tarde',
                "eng"=>'Service down, please try again later'), $lang, "Servicio inactivo, intente más tarde")));
            break;
        case 1:
            // Consultamos el listado de bancos
            $headers = array('Content-Type:application/json');
            $request = array();
            $rest = queryApiBP($BP_URL_QA, "pagos/p2p/bancos", $BP_VERSION_P2P, "GET", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                switch($rest['httpres']){
                    case 503:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'El servidor no puede atender temporalmente su petición',
                            "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petición")));
                        break;
                    default:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'Error llamada a API BP',
                            "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
                }
            }
        
            $banks = $rest['bancos'];
            
            $bankid = '';
            // recorremos los bancos para sacar el code a partir del nombre para la API
            foreach($banks as $bank){
                if ($bank['nombre'] == $pagomovildata['bankname']) {
                    $bankid = $bank['codigo'];
                }
            }
        
            // Necesitamos
            $ci = $pagomovildata['docid'];
            $phone = $pagomovildata['phone'];
            $amount = $pagomovildata['amounttx'];
            
            // EJECUTAMOS EL PAGO MOVIL
            $nonce = generateNonce();
            
            // Llamamos a la api primerito
            $request = array(
                'banco'=>$bankid,
                'idBeneficiario'=>$ci,
                'telefono'=>$phone,
                'monto'=>(float)number_format($amount, $currency['decimals'], '.', ''),
                'motivo'=>'Retiro AFX',
                'canal'=>'23',
                'id-externo'=>$id
            );
        
           $headers = array('Content-Type:application/json', 
                "api-key: $BP_C2P_KEY", 
                "api-signature: ".
                (
                    generateApiSignature("/".$BP_VERSION_P2P."/pagos/p2p".$nonce.json_encode($request),$BP_C2P_KEY_SECRET)
                ),
                "nonce: ".$nonce,
            );
            
            // obtenemos respuesta
            $rest = queryApiBP($BP_URL_QA, "pagos/p2p", $BP_VERSION_P2P, "POST", $headers, $request);
        
            // IMPORTANTE CAMBIAR LA VALIDACION DE LA APIKEY A004
            if(($rest['bodyres']->referencia == null || $rest['bodyres']->referencia == '') && $rest['httpres'] != 200 && $rest['httpres'] != 201 /*&& $rest['headerres']['codigorespuesta'] !== 'A004'*/){
                $msg_esp = "";
                $msg_eng = "";
                
                switch($rest['headerres']['codigorespuesta']){
                    case 'E028':
                        $msg_esp = "El código de operaciones ingresado es inválido. Por favor intente de nuevo";
                        $msg_eng = "The operations code is invalid. Please try again";
                        break;
                    case 'E010':
                        $msg_esp = "Monto no válido";
                        $msg_eng = "Invalid amount";
                        break;
                    case 'E012':
                        $msg_esp = "Teléfono no habilitado para pagar";
                        $msg_eng = "Phone not enabled to pay";
                        break;
                    case 'E013':
                        $msg_esp = "Excede cantidad de pagos diarios";
                        $msg_eng = "Exceeds amount of daily payments";
                        break;
                    case 'E014':
                        $msg_esp = "Excede monto total de pagos diarios";
                        $msg_eng = "Exceeds total amount of daily payments";
                        break;
                    case 'E015':
                        $msg_esp = "Excede monto máximo para un pago";
                        $msg_eng = "Exceeds maximum amount for a payment";
                        break;
                    case 'E016':
                        $msg_esp = "Excede cantidad de pagos diarios";
                        $msg_eng = "Exceeds amount of daily payments";
                        break;
                    case 'E017':
                        $msg_esp = "Excede monto total de pagos diarios";
                        $msg_eng = "Exceeds total amount of daily payments";
                        break;
                    case 'E018':
                        $msg_esp = "Error en número de banco";
                        $msg_eng = "Bank number error";
                        break;
                    case 'E021':
                        $msg_esp = "Teléfono receptor no registrado";
                        $msg_eng = "Receiving phone not registered";
                        break;
                    case 'E022':
                        $msg_esp = "Teléfono receptor no acepta pagos";
                        $msg_eng = "Receiving phone does not accept payments";
                        break;
                    case 'E023':
                        $msg_esp = "Identificación del beneficiario no coincide";
                        $msg_eng = "Beneficiary ID does not match";
                        break;
                    case 'E024':
                        $msg_esp = "Cliente bloqueado";
                        $msg_eng = "Client blocked";
                        break;
                    case 'E030':
                        $msg_esp = "Banco no activo en pago móvil";
                        $msg_eng = "Bank not active in mobile payment";
                        break;
                    case 'A001':
                        $msg_esp = "Firma digital inválida";
                        $msg_eng = "Invalid digital signature";
                        break;
                    case 'A004':
                        $msg_esp = "Api-key invalida o revocado";
                        $msg_eng = "Api-key invalid";
                        break;
                    default:
                        $msg_esp = $rest['headerres']['descripcioncliente'];
                        $msg_eng = $rest['headerres']['descripcioncliente'];
                }
                $msg_esp = $msg_esp." Codigo: ".$rest['headerres']['codigorespuesta'];
                $msg_eng = $msg_eng." Codigo: ".$rest['headerres']['codigorespuesta'];
                deleteTransactions($db, $id, $lang, $msg_esp);
            }
            
            if($rest['headerres']['codigorespuesta'] == '0084'){
                $reference = '0000';
                // QUITAR A004 CUANDO SE SOLUCIONE LO DE LA APIKEY
            }else/* if ($rest['headerres']['codigorespuesta'] === 'A004') {
                $reference = randomString(24);
            }else*/{
                $reference = $rest['bodyres']->numeroReferencia;
            }
        
            break;
        case 2:
            
            // Consultamos la api de banco activo
            $headers = array('Content-Type:application/json','apikey: '.$BA_API_KEY);
            $request = array("tipo_pagador"=>"P2P");
            $rest = queryApiBA($BA_URL_QA."lista_banco_pago_movil/1.0.0/bancos", "POST", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                $msgs = validateErrorBancoActivo($rest['bodyres']->code, $rest['bodyres']->descripcion, $rest['bodyres']->descripcion);
                $msg_esp = $msgs->msg_esp;
                $msg_eng = $msgs->msg_eng;
                                
                $msg_esp = $msg_esp;
                $msg_eng = $msg_eng;
                
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>$msg_esp,
                    "eng"=>$msg_eng), $lang, $msg_esp)));
            }
            
            $bankid = '';
            $bancos = $rest['bodyres']->bancos;
            foreach($bancos as $bank){
                if ($bank->nombreBanco == $pagomovildata['bankname']) {
                    $bankid = $bank->codBanco;
                }
            }
            
            $ci = $pagomovildata['docid'];
            $phone = $pagomovildata['phone'];
            $amount = $pagomovildata['amounttx'];
            
            // Llamamos a la api primerito
            $request = array(
                'usuario'=>$rifafxAPI, // Usuario
                'cedula_pagador'=>$rifafxAPI,
                'telefono_pagador'=>intval("58".$BA_phoneAFX),
                'tipo_cuenta'=> '0001',
                'bco_benef'=>$bankid,
                'cedula_benef'=>$ci,
                'telefono_benef'=>intval("58".$phone),
                'monto'=>number_format($amount, $currencydata['decimals'], ',', ''),
                'motivo'=>'Retiro AFX',
                'area_origen'=>'01',
            );
            
            // Consultamos la api de banco activo
            $headers = array('Content-Type:application/json','apikey: '.$BA_API_KEY);
            $rest = queryApiBA($BA_URL_QA."pago/p2p/1.0.0/p2p", "POST", $headers, $request);
            
            if(($rest['bodyres']->nroReferencia == null || $rest['bodyres']->nroReferencia == '') && $rest['httpres'] != 200 && $rest['httpres'] != 201){
                
                $msgs = validateErrorBancoActivo($rest['bodyres']->code, $rest['bodyres']->descripcion, $rest['bodyres']->descripcion);
                $msg_esp = $msgs->msg_esp;
                $msg_eng = $msgs->msg_eng;
                                
                $msg_esp = $msg_esp;
                $msg_eng = $msg_eng;
                                    
                deleteTransactions($db, $id, $lang, $msg_esp);
            }
            
            $reference = $rest['bodyres']->nroReferencia;
        break;
    }
    
    //Actualizamos la transaccion
    $sql = "UPDATE transactions SET".
    "       amount = amount + amountghost, ".
    "       validthru = NULL, ".
    "       amountghost = 0, ".
    "       paypending = 0, ".
    "       validator = NULL ".
    "       WHERE txid = ".$id.
    "       AND validthru > NOW()".
    "       AND validator = ".$secretcode;
    if (!$db->query($sql)){
        $error = determinateDBError($db);
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Actualizamos la tabla de retiros
    $sql = "UPDATE withdrawals SET".
    "       pagomovilbankid = ".$bankinterface.
    "       WHERE transactionid = ".$id;
    if (!$db->query($sql)){
        $error = determinateDBError($db);
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    $sql = "UPDATE pagomovildetails SET".
    "       pagomovilbankid = ".$bankinterface.",".
    "       ref = '".$reference."' ".
    "       WHERE transactionid = ".$id;
    if (!$db->query($sql)){
        $error = determinateDBError($db);
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    $db->commit();
    
    $db->autocommit(TRUE);

    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "PAY", "Se registró un pago móvil por ".$amount." en ".$currency['name'].", del usuario ".$userdataaudit['name'], $ipaddress);
    
    // Retornamos la data
    $out->txid = $reference;
    $out->transaction = new stdClass();
    $out->transaction->id = $id;
    
    // Main ??
    $out->transaction->main = new stdClass();
    $out->transaction->main->currency = new stdClass();
    $out->transaction->main->currency->id = $currency['id'];
    $out->transaction->main->currency->symbol = $currency['symbol'];
    $out->transaction->main->currency->name = $currency['name'];
    
    $out->transaction->main->amount = new stdClass();
    $out->transaction->main->amount->number = (float)bcdiv(number_format($amount,13, '.', ''), '1',$currency["decimals"]);
    $out->transaction->main->amount->formatted = numberFormatt($out->transaction->main->amount->number,$currency["decimals"]);
    
    // Destino
    $out->transaction->destination = new stdClass();
    $out->transaction->destination->c2pbank = new stdClass();
    $out->transaction->destination->c2pbank->code = $bankid;
    $out->transaction->destination->c2pbank->name = $pagomovildata['bankname'];
    $out->transaction->destination->mobilephone = $phone;
    $out->transaction->destination->docid = $ci;
    
    // origen
    $out->transaction->origin = new stdClass();
    $out->transaction->origin->c2pbank = new stdClass();
                
    switch($bankinterface){
        case 1:
            $out->transaction->origin->c2pbank->name = $BP_NAME;
            $out->transaction->origin->mobilephone = $phoneAFX;
            $out->transaction->origin->docid = trim($rifafx, "-");
            break;
        case 2:
            $out->transaction->origin->c2pbank->name = $BA_NAME;
            $out->transaction->origin->mobilephone = $BA_phoneAFX;
            $out->transaction->origin->docid = trim($rifafx, "-");
            break;
    }
    
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function deleteTransactions($db, $txid, $lang, $msg = ""){
        //Abrimos la transaccion
        $db->autocommit(FALSE);

        //eliminar el retiro(si existe)
        $sql = "DELETE FROM withdrawals WHERE transactionid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //eliminar la transaccion
        $sql = "DELETE FROM transactions ".
        "       WHERE id = ".$txid.
        "       OR txid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //Retornamos 304 si no se elimino ningun registro
        if ($db->affected_rows == 0){
            $db->rollback();
            $db->close();   
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"No se pudo modificar",
                "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
        }
    
        $db->commit();
        $db->close();
            
        badEnd('500',array("msg"=>$msg));
    }
?>