<?php
//pay/api/sendmoney/preparepagomovil
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('accountid', 'c2pbank', 'doctype', 'doc', 'mobilephone', 'amount');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $accountid = $_POST['accountid'];
    $c2pbank = $_POST['c2pbank'];
    $doctype = $_POST['doctype'];
    $doc = $_POST['doc'];
    $mobilephone = $_POST['mobilephone'];
    $amount = $_POST['amount'];
    $obs = $_POST['obs'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer operaciones
    isLevelValid($db, $userid);
    
    // Validamos el tipo de cedula qlq
    $kindoc = array("V", "E", "J");
    if (!in_array($doctype, $kindoc)) {
        badEnd("403", array("msg"=> "Tipo de documento debe ser: " . implode(", ", $kindoc)));
    }
    
    if($amount <= 0){
        badEnd("403", array("msg"=> "Monto no puede ser menor o igual a 0"));
    }
    
    // Obtenemos los datos de la cuenta del usuario
    $sql = "SELECT * FROM accounts ".
    "       WHERE id = ".$accountid.
    "       AND userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $accountdata = $rs->fetch_assoc();
    $currencyid = $accountdata['currencyid'];
    
    // Obtenemos los datos de la moneda
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currency = $rs->fetch_assoc();
    
    // Obtenemos los datos del BS
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencyfiat = $rs->fetch_assoc();
    
    // Obtenemos la cuenta AFX del usuario
    $sql = "SELECT id FROM accounts  ".
    "       WHERE currencyid = ".$currencyid.
    "       AND paymentmethodid = -1 " .
    "       AND accounts.entityusrid = -1 ".
    "       AND userid=".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db).$sql));
        
    $account = $rs->fetch_assoc();
    
    // Consultamos de la vista ya creada con el balance
    $sql = "SELECT * FROM accountbalances WHERE accountid = ".$accountid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $balancetx = $res->fetch_assoc();
    
    if(
        number_format($balancetx["balance"], $currency['decimals'], '.', '') <= 0 ||
        number_format($balancetx["balance"], $currency['decimals'], '.', '') < $amount
    ){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Consultamos la cuenta que tiene los saldos de los pago moviles
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -7";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdatabalances = $rs->fetch_assoc();
    
    //Consultamos la cuenta que tiene la moneda del retiro de AFX
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -6";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    // Buscamos la cuenta de comision de AFX para retiros
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -2";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdatawithdrawal = $rs->fetch_assoc();
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currency["id"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    //Validamos que el monto sea mas que el minimo aceptado para transferencia
    if(validateMin($accountdata["currencyid"],$userdata["type"], 2, $db, $amount)){
        badEnd("403", array("msg"=> "Monto m&iacute;nimo autorizado: ".numberFormatt($fee['minxfer'], $currency['decimals'])));
    }
    
    // SACAMOS LA COMISION PARA PAGO MOVIL PRIMERO
    $feepagomovil = 0;
    if($fee["pagomovilpct"] != null){
        // Obtenemos el exonerado para depositos si posee
        $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
        "       WHERE currencyid = ".$accountdata["currencyid"].
        "       AND userid = ".$userdata['id'].
        "       AND preffeesfield = 'pagomovilpct'";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $userExg = $res->fetch_assoc();
        
        $feepagomovil = number_format((($fee["pagomovilpct"] - ($fee["pagomovilpct"]/100 * $userExg['exonerated']) )*$amount)/100, $currency['decimals'], '.', '');
    }
    
    // SACAMOS LA COMISION PARA RETIRO PORCENTAJE FIAT
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currencyfiat["id"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
        
    $feewithdrawal = 0;
    if($fee["pctfeewithdrawals"] != null || $fee["nmlfeewithdrawals"] != null ){
        if($fee["pctfeewithdrawals"] == null){
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$accountdata["currencyid"].
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'nmlfeewithdrawals'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $feewithdrawal = number_format($amount - ($amount - ($fee["nmlfeewithdrawals"] - ($fee["nmlfeewithdrawals"]/100 * $userExg['exonerated']) )), $currency['decimals'], '.', '');
        }else{
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$accountdata["currencyid"].
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'pctfeewithdrawals'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $feewithdrawal = number_format((($fee["pctfeewithdrawals"] - ($fee["pctfeewithdrawals"]/100 * $userExg['exonerated']) )*$amount)/100, $currency['decimals'], '.', '');
        }
    }
    
    // AHORA VEMOS SI TIENE SUFICIENTE SALDO CON LAS COMISIONES
    if(
        number_format($balancetx["balance"], $currency['decimals'], '.', '') < number_format($amount + $feewithdrawal + $feepagomovil, $currency['decimals'], '.', '')
    ){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    $validator = getValidator(8);
    
    validateOperations($db, $accountid, $userid, $amount, 3);
    
    // Obtenemos el rate de la moneda para VES para la descripcion
    $rate = determinateRate($db, $currency['id'], $currencyfiat["id"], $currency['decimals']);
    $showedAmountVes = number_format($rate->number * $amount, $currencyfiat['decimals'], '.', '');
    
    $db->autocommit(FALSE);
    
    //insertamos el retiro desde el origen
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Venta de ".$currency['symbol']." por servicio Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$accountdata["id"].", ".
    "       NULL, ".
    "       -".$amount.", ".
    "       0, ".
    "       ".$afxdatabalances['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion
    $txid = (int)$db->insert_id;
    
    //Le colocamos el primer movimiento el txid
    $sql = "UPDATE transactions SET".
    "       txid= ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos el fee del retiro del origen pago movil y sumamos a la comision de pago movil
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Nuevo Servicio Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$accountdata["id"].", ".
    "       ".$txid.", ".
    "       NULL, ".
    "       -".$feepagomovil.", ".
    "       0, ".
    "       ".$afxdata['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos el fee del retiro del origen comision de retiro a la cuenta de comision retiro
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Retiro Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$accountdata["id"].", ".
    "       ".$txid.", ".
    "       NULL, ".
    "       -".$feewithdrawal.", ".
    "       0, ".
    "       ".$afxdatawithdrawal['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Ingresamos el dinero de AFX
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Ingreso AFX por servicio de retiro Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$afxdatabalances["id"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["id"].", ".
    "       ".$amount.", ".
    "       0, ".
    "       ".$afxdatabalances['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Ingresamos la comision de pago movil que recibe AFX
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Nuevo Servicio Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$afxdata["id"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["id"].", ".
    "       ".$feepagomovil.", ".
    "       0, ".
    "       ".$afxdata['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Ingresamos la comision de retiro que recibe AFX
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Nuevo Servicio Pago Móvil de ".$showedAmountVes." ".$currencyfiat['symbol']."', ".
    "       ".$afxdatawithdrawal["id"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["id"].", ".
    "       ".$feewithdrawal.", ".
    "       0, ".
    "       ".$afxdatawithdrawal['id'].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       -1".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Consultamos el listado de bancos
    $headers = array('Content-Type:application/json');
    $request = array();
    $rest = queryApiBP($BP_URL_QA, "pagos/c2p/bancos", $BP_VERSION, "GET", $headers, $request);
    
    if($rest['httpres'] != 200 && $rest['httpres'] != 201){
        switch($rest['httpres']){
            case 503:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'El servidor no puede atender temporalmente su petición',
                    "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petición")));
                break;
            default:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'Error llamada a API BP',
                    "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
        }
    }
    
    $banks = $rest['bancos'];
    $bankname = '';
    // recorremos los bancos para sacar el nombre a partir del code
    foreach($banks as $bank){
        if ($bank['codigo'] == $c2pbank) {
            $bankname = $bank['nombre'];
        }
    }
    
    // Insertamos el movimiento en la tabla de pago moviles
    $sql = "INSERT INTO pagomovildetails ".
    "       (".
    "           transactionid, ".
    "           bankname, ".
    "           docid, ".
    "           phone, ".
    "           notes, ".
    "           amounttx, ".
    "           currencytx ".
    "       ) ".
    "       VALUES ".
    "       (".
    "           ".$txid.", ".
    "           '".$bankname."', ".
    "           '".$doctype.$doc."', ".
    "           '".$mobilephone."', ".
    "           '".$obs."', ".
    "           ".$showedAmountVes.", ".
    "           ".$currencyfiat['id']." ".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    // Retornamos la data
    $out->transaction = new stdClass();
    $out->transaction->id = $txid;
    
    // Main ??
    $out->transaction->main = new stdClass();
    $out->transaction->main->currency = new stdClass();
    $out->transaction->main->currency->id = $currencyfiat['id'];
    $out->transaction->main->currency->symbol = $currencyfiat['symbol'];
    $out->transaction->main->currency->name = $currencyfiat['name'];
    
    $out->transaction->main->amount = new stdClass();
    $out->transaction->main->amount->number = $showedAmountVes;
    $out->transaction->main->amount->formatted = numberFormatt($out->transaction->main->amount->number,$currencyfiat["decimals"]);;
    
    // Cuenta de origen
    $out->transaction->wallet = new stdClass();
    $out->transaction->wallet->currency = new stdClass();
    $out->transaction->wallet->currency->id = $currency['id'];
    $out->transaction->wallet->currency->symbol = $currency['symbol'];
    $out->transaction->wallet->currency->name = $currency['name'];
    
    $out->transaction->wallet->amount = new stdClass();
    $out->transaction->wallet->amount->number = $amount;
    $out->transaction->wallet->amount->formatted = numberFormatt($out->transaction->wallet->amount->number, $currency['decimals']);
    
    $out->transaction->wallet->fee = new stdClass();
    $out->transaction->wallet->fee->number = number_format($feewithdrawal + $feepagomovil, $currency['decimals'], '.', '');
    $out->transaction->wallet->fee->formatted = numberFormatt($out->transaction->wallet->fee->number, $currency['decimals']);
    
    $out->transaction->wallet->total = new stdClass();
    $out->transaction->wallet->total->number = number_format($amount + $feewithdrawal + $feepagomovil, $currency['decimals'], '.', '');
    $out->transaction->wallet->total->formatted = numberFormatt($out->transaction->wallet->total->number, $currency['decimals']);

    // Tasa
    $out->transaction->rate = $rate;
    
    // Destino
    $out->transaction->destination = new stdClass();
    $out->transaction->destination->c2pbank = new stdClass();
    $out->transaction->destination->c2pbank->code = $c2pbank;
    $out->transaction->destination->c2pbank->name = $bankname;
    $out->transaction->destination->mobilephone = $mobilephone;
    $out->transaction->destination->docid = $doctype."-".$doc;
    
    $db->commit();
    $db->close();
    
    $email = $userdata["usr"];
    $subject = "Código de Transferencia ".$shortname;
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $styleTag = 
        "<style rel='stylesheet' type='text/css'>".
        "           .emailBox {".
        "               background-color: #F8F8FA;".
        "               padding: 20px;".
        "           }".
        "           .copy {".
        "               font-family: 'Roboto', sans-serif;".
        "               font-weight: 400;".
        "               font-size: 12px;".
        "               margin-top:40px;".
        "               color: #767E93;".
        "               text-align:center;".
        "           }".
        "           .mainBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #FFF;".
        "               border-radius: 22px;".
        "               width: 60%;".
        "               padding:30px;".
        "           }".
        "           .msg { ".
        "               font-size: 18px;".
        "               color: #474C58;".
        "               text-align:center;".
        "               margin-bottom:30px;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .titleEmail {".
        "               color:#474C58;".
        "               text-align:center;".
        "               font-size: 20px;".
        "               font-weight: bold;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .note {".
        "               text-align:center;".
        "               font-size:12px;".
        "               color: #474C58;".
        "           }".
        "           .code {".
        "               margin: auto;".
        "               display: block;".
        "               color: #FFF;".
        "               font-size: 18px;".
        "               text-align:center;".
        "               line-height: 58px;".
        "               font-weight:bold;".
        "               letter-spacing: 10px;".
        "           }".
        "           .validatorBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #4287CE;".
        "               border-radius: 8px;".
        "               width: 200px;".
        "               height: 57px;".
        "               text-align:center;".
        "           }".
        "           @media (max-width: 450px) {".
        "               .mainBox {".
        "                   width: 95% !important;".
        "                   padding: 25px 0px;".
        "               }".
        "               .emailBox {".
        "                   padding: 0px;".
        "               }".
        "               .titleEmail {".
        "                   font-size: 18px;".
        "               }".
        "               .msg, .code {".
        "                   font-size: 14px;".
        "               }".
        "           }".
        "</style>";
        $body = 
            "<div class='emailBox'>".
            "   <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."./settings/img/logo-email.png'/>".
            "   <div class='mainBox'>".
            "       <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer.png'/>".
            "       <h1 class='titleEmail'>Hola ".strtolower($email)."</h1>".
            "       <p class='msg'>".
            "           Para completar la transferencia de fondos ingrese el c&oacute;digo a continuaci&oacute;n".
            "       </p>".
            "       <div class='validatorBox'>".
            "           <p class='code'>".$validator."</p>".
            "       </div>".
            "       <p class='note'>".
            "           Este c&oacute;digo expirar&aacute; en 10 minutos".
            "       .</p>".
            "   </div>".
            "   <p class='copy'>".$footerEmails."</p>".
            "</div>";
            
    $body = templateEmail($body, $styleTag);
            
    enviarCorreo2($fromeMail, strtolower($email), $subject, $body);
    
    $msg = 'Para completar la transferencia de fondos ingrese el código a continuación: '.$validator;
    enviarSMS($userdata['phone'], $msg." \n rEl8y+fS/0G");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>