<?php
//pay/api/sendmoney/send
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array('sessionid', 'usriddest', 'amount', 'accountid');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $_GET['sessionid'];
    $usriddest = $_GET['usriddest'];
    $amount = $_GET['amount'];  
    $accountid = $_GET['accountid'];
    $usriddestInserted = null;
    $levelDest = 0 ;
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer transferencias
    isLevelValid($db, $userid);
    
    //Consultamos los datos del usuario que realiza la transferencia
    $sql = "SELECT accounts.currencyid AS accurrencyid, ".
    "       accounts.id AS accountid ".
    "       FROM accounts, payusers ".
    "       WHERE accounts.userid = payusers.userid ".
    "       AND payusers.sessionid = '".$sessionid."' ".
    "       AND accounts.id = ".$accountid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdata = $rs->fetch_assoc();
    
    if($accountdata['accountid'] == null){
        badEnd("500",array("msg"=>"accountid no encontrado"));
    }
    
    //Consultamos los datos de la moneda para validar que tipo es y decimales
    $sql = "SELECT * FROM currencies ".
    "       WHERE id = ".$accountdata["accurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currencydata = $rs->fetch_assoc();
    
    $amount = number_format($amount, $currencydata['decimals'], '.', '');
    
    $sql = "SELECT SUM(amount) - ABS(IF(( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1) IS NOT NULL,  ".
	"               ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
	"           AND orders.type != 1), 0)".
    "       + IF(( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountid.
    "           AND orders.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0 ".
	"           AND orders.type != 1) IS NOT NULL, ( ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountid.
    "           AND orders.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0 ".
	"           AND orders.type != 1),0) ".
	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"           FROM transactions  ".
	"           WHERE transactions.paypending = 1".
	"           AND transactions.accountid = ".$accountid.
	"           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
	"           (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
	"           FROM transactions  ".
	"           WHERE transactions.paypending = 1".
	"           AND transactions.accountid = ".$accountid.
	"           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
	"      ) as qty FROM transactions WHERE accountid = ".$accountid.
    "       AND paypending = 0";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $balancetx = $res->fetch_assoc();
    
    if(
        number_format($balancetx["qty"], $currencydata['decimals'], '.', '') <= 0 ||
        number_format($balancetx["qty"], $currencydata['decimals'], '.', '') < $amount
    ){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT users.* FROM payusers, users ".
    "       WHERE payusers.sessionid = '".$sessionid."'".
    "       AND users.id = payusers.userid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = $userdata["level"];
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$accountdata["accurrencyid"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
        
    //Calculamos el monto real quitandole la comision
    if($fee["pctfeexfer"] != null || $fee["nmlfeesxfer"] != null ){
        if($fee["pctfeexfer"] == null){
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$accountdata["accurrencyid"].
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'nmlfeesxfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $realfee = number_format($amount - ($amount - ($fee["nmlfeesxfer"] - ($fee["nmlfeesxfer"]/100 * $userExg['exonerated']) )), $currencydata['decimals'], '.', '');
            $realamount = number_format($amount - $realfee, $currencydata['decimals'], '.', '');
        }else{
            
            // Obtenemos el exonerado para depositos si podee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$accountdata["accurrencyid"].
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'pctfeexfer'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $realfee = number_format((($fee["pctfeexfer"] - ($fee["pctfeexfer"]/100 * $userExg['exonerated']) )*$amount)/100, $currencydata['decimals'], '.', '');
            $realamount = number_format($amount - $realfee, $currencydata['decimals'], '.', '');
        }
    }else{
        $realfee = 0;
        $realamount = number_format($amount - $realfee, $currencydata['decimals'], '.', '');
    }
    
    //Validamos que el monto sea mas que el minimo aceptado
    if(validateMin($accountdata["accurrencyid"],$userdata["type"], 2, $db, $amount)){
        badEnd("403", array("msg"=>"Monto m&iacute;nimo autorizado: ".numberFormatt($fee['minxfer'], $currencydata['decimals'])." ".$currencydata['symbol']));
    }
    
    if($realamount <= 0){
        badEnd("403", array("msg"=>"Monto no permitido. Pruebe con un monto más alto.","amount"=>$realamount));
    }
    
    //Consultamos la cuenta que tiene la moneda del transferencia de AFX
    $sql = "SELECT * FROM accounts WHERE userid = -1".
    "       AND currencyid = ".$accountdata["accurrencyid"].
    "       AND paymentmethodid = -4";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    //Obtenemos los datos de la moneda para saber si es cripto o FIAT
    $sql = "SELECT * FROM currencies WHERE id = ".$accountdata["accurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta AFX
    $row = $rs->fetch_assoc();
    
    $currencydata = $row;
    
    validateOperationsPay($db, $accountid, $userid, $amount, 3);
    
    //Consultamos los datos maximos
    $sql = "SELECT cmspreffees.* ".
    "       FROM cmspreffees ".
    "       WHERE cmspreffees.currencyid = -1";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("msg"=>$db->error.$sql));
    }
    
    $row = $rs->fetch_assoc();
    
    if ($usriddest == 0) {
        // parametros obligatorios si no existe en AFX
        $parmsob = array('name','lastname','email','mobilephone', 'doctype', 'doc');
        if (!parametrosValidos($_GET, $parmsob)){
            badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob), "a"=>$_GET));
        }
        
        // Validamos el correo
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM users ".
        "       WHERE UPPER(usr)=UPPER('".$_GET['email']."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userexist = $rs->fetch_assoc();
            
        if($userexist["qty"] == 0){
            
            $rateRealAmount = determinateRate($db, -1, $accountdata["accurrencyid"], 13);
            
            //Validamos si el monto total + monto operacion actual no excede el limite
            if(number_format($realamount, $currencydata['decimals'], '.', '') >= number_format(($row["maxamountopsendpay"] * $rateRealAmount->number), $currencydata['decimals'], '.', '')){
                badEnd("403", array("msg"=>"No puede enviarle esa cantidad a ".$_GET['email'].", Puede recibir ".(($row["maxamountopsendpay"] * $rateRealAmount->number))." ".$currencydata['symbol']));
            }
            
            $hash = randomString(128);
            
            // Creamos el usuario
            $sql = "INSERT INTO users(usr, pwd, status, datecreated, activatenro, lang, sessionid, level, type, paymobilephone, validthru)".
            "       VALUES ('".strtolower($_GET['email'])."', ".
            "       '', ".
            "       0, NOW(), NULL, ".
            "       'esp', ".
            "       '".$hash."', ".
            "       0, ".
            "       1, ".
            "       '".$_GET['mobilephone']."', ".
            "       DATE_ADD(NOW(), INTERVAL 1 DAY)".
            ")";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            // Retornamos el id que fue insertado
            $usriddestInserted = (int)$db->insert_id;
            
            $nameAudit = $_GET['email'];
            
            // Obtenemos el id de venezuela
            $sql = "SELECT id FROM countries WHERE name LIKE '%Venezuela%'";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $country = $rs->fetch_assoc();
            
            $sql = "INSERT INTO userpersons(usrid, phone, venezuelan, countryid, doctype, doc) ".
            "       VALUES (".
            "       ".$usriddestInserted.", '".$_GET['mobilephone']."', 1, ".$country['id'].", ".$_GET['doctype'].", '".$_GET['doc']."' ".
            "       )";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            // Obtenemos las 4 primeras monedas con el XFER activo
            $sql = "SELECT id FROM currencies ".
            "       WHERE xfer = 1 ".
            "       AND status = 1 ".
            "       AND id > 0 ".
            "       LIMIT 0, 4";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $count = 0;
            $currAcepted = '';
            
            while($row = $rs->fetch_assoc()) {
                if ($count == 0) {
                    $currAcepted .= $row['id'];
                } else {
                    $currAcepted .= ",".$row['id'];
                }
                $count++;
            }
                
            // Insertamos el hash del registro en pay
            $sql = "INSERT INTO payusers(userid, sessionid, datecreated, validthru, receivecurrencies, sendcurrencies, acceptedcurrencies)".
            "       VALUES (".$usriddestInserted.", ".
            "       '".$hash."', ".
            "       NOW(), ".
            "       DATE_ADD(NOW(), INTERVAL 1 DAY), ".
            "       '".$currAcepted."', ".
            "       '".$currAcepted."', ".
            "       '".$currAcepted."' ".
            ")";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }else{
            
            // Obtenemos su ID
            $sql = "SELECT * FROM users WHERE UPPER(usr)=UPPER('".$_GET['email']."')";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $userexist = $rs->fetch_assoc();
            
            // Obtenemos las xfer por paypending = 1 y userid del usuario
            $sql = "SELECT transactions.amount AS amount, ".
            "       IF(acc.currencyid IS NULL, accounts.currencyid, acc.currencyid) AS currencyid ".
            "       FROM users, accounts, transactions ".
            "       LEFT JOIN  accounts acc ON acc.id = transactions.accountdestination AND acc.userid = ".$usriddest.
            "       WHERE transactions.paypending = 1  ".
            "       AND transactions.id = transactions.txid  ".
            "       AND transactions.accountorigin = accounts.id ".
            "       AND (acc.userid = users.id OR transactions.accountdestination = users.id)  ".
            "       AND users.pwd = '' ".
            "       AND (transactions.accountdestination = ".$usriddest." OR acc.id IS NOT NULL)";
            if (!$resxfer=$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            $validateamount = 0;
            while($transRow = $resxfer->fetch_assoc()){
                $rateTmp = determinateRate($db, -1, $transRow['currencyid'], 13);
                
                $validateamount += abs($transRow['amount']) / $rateTmp->number;
            }
            
            
            $rateRealAmount = determinateRate($db, -1, $accountdata["accurrencyid"], 13);
            
            //Validamos si el monto total + monto operacion actual no excede el limite
            if(number_format(($validateamount * $rateRealAmount->number) + $realamount, $currencydata['decimals'], '.', '') >= number_format(($row["maxamountopsendpay"] * $rateRealAmount->number), $currencydata['decimals'], '.', '')){
                badEnd("403", array("msg"=>"No puede enviarle esa cantidad a ".$_GET['email'].", Puede recibir ".number_format(($row["maxamountopsendpay"] * $rateRealAmount->number)-abs(($validateamount * $rateRealAmount->number)), $currencydata['decimals'], ',', '.')." ".$currencydata['symbol']));
            }
            
            // Validamos si tiene cuentas creadas de PAY
            $sql = "SELECT COUNT(accounts.id) AS qty ".
            "       FROM accounts ".
            "       WHERE accounts.paymentmethodid = -1 ".
            "       AND accounts.status = 1".
            "       AND accounts.userid = ".$userexist['id'];
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $accounts = $res->fetch_assoc();
            
            // Retornamos el id que fue insertado
            // Dependiendo de si tienes cuenta o no
            if ($accounts['qty'] > 0) {
                $usriddest = (int)$userexist['id'];
            } else {
                $usriddestInserted = (int)$userexist['id'];
            }
        }
    }
    
    
    if($usriddest != 0){
        
        //Origen de la transferencia
        $usrorigin = $userdata["usr"];
        
        //Consultamos el id del usuario
        $sql = "SELECT id, pwd ".
        "       FROM users ".
        "       WHERE id = ".$usriddest;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userdesdata = $rs->fetch_assoc();
            
        if($userdesdata["id"] == null){
            badEnd("404",array("msg"=>"Usuario no encontrado"));
        }
        
        if ($userdesdata["pwd"] == null || $userdesdata["pwd"] == '') {
            // Obtenemos las xfer por paypending = 1 y userid del usuario
            $sql = "SELECT transactions.amount AS amount, ".
            "       IF(acc.currencyid IS NULL, accounts.currencyid, acc.currencyid) AS currencyid ".
            "       FROM users, accounts, transactions ".
            "       LEFT JOIN  accounts acc ON acc.id = transactions.accountdestination AND acc.userid = ".$usriddest.
            "       WHERE transactions.paypending = 1  ".
            "       AND transactions.id = transactions.txid  ".
            "       AND transactions.accountorigin = accounts.id ".
            "       AND (acc.userid = users.id OR transactions.accountdestination = users.id)  ".
            "       AND users.pwd = '' ".
            "       AND (transactions.accountdestination = ".$usriddest." OR acc.id IS NOT NULL)";
            if (!$resxfer=$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            $validateamount = 0;
            while($transRow = $resxfer->fetch_assoc()){
                $rateTmp = determinateRate($db, -1, $transRow['currencyid'], 13);
                
                $validateamount += abs($transRow['amount']) / $rateTmp->number;
            }
            
            $rateRealAmount = determinateRate($db, -1, $accountdata["accurrencyid"], 13);
            
            //Validamos si el monto total + monto operacion actual no excede el limite
            if(number_format(($validateamount * $rateRealAmount->number) + $realamount, $currencydata['decimals'], '.', '') >= number_format(($row["maxamountopsendpay"] * $rateRealAmount->number), $currencydata['decimals'], '.', '')){
                badEnd("403", array("msg"=>"No puede enviarle esa cantidad a ".$_GET['email'].", Puede recibir ".number_format(($row["maxamountopsendpay"] * $rateRealAmount->number)-abs(($validateamount * $rateRealAmount->number)), $currencydata['decimals'], ',', '.')." ".$currencydata['symbol']));
            }
        }
        
        //Validamos que el usuario no se este transfiriendo a si mismo
        $sql = "SELECT id, usr, level, type, pwd ".
        "       FROM users ".
        "       WHERE id = ".$usriddest;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userdesdata = $rs->fetch_assoc();
            
        if($userdesdata["usr"] == $userdata['usr']){
            badEnd("400",array("msg"=>"No puedes transferir a si mismo"));
        }
        
        $levelDest = $userdesdata["level"];
        
        if($userdesdata["level"] == 0 && $userdesdata['pwd'] != null){
            //badEnd("404",array("msg"=>"Usuario no verificado en AFX"));
        }
        
        // Validamos si tiene cuentas creadas de PAY
        $sql = "SELECT COUNT(accounts.id) AS qty ".
        "       FROM accounts ".
        "       WHERE accounts.paymentmethodid = -1 ".
        "       AND accounts.status = 1".
        "       AND accounts.userid = ".$userdesdata['id'];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $accounts = $res->fetch_assoc();
        
        if ($accounts['qty'] > 0) {
            
            //Consultamos los datos del usuario de destino
            $sql = "SELECT accounts.id AS accountid ".
            "       FROM accounts, users ".
            "       WHERE accounts.userid = users.id ".
            "       AND users.id = ".$usriddest.
            "       AND accounts.currencyid = ".$accountdata["accurrencyid"].
            "       AND accounts.paymentmethodid = -1";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $accountdestination = $rs->fetch_assoc();
            
            //Si el usuario posee una cuenta en la moneda de origen puede continuar
            //Si no se le genera una
            if($accountdestination["accountid"] == null){
                
                //Validamos si es una criptomoneda o fiat
                $isCripto = false;
                $isFiat = false;
            
                if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 3 || intval($currencydata['interface']) == 2){
                    $isFiat = true;
                }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6 || intval($currencydata['interface']) == 7){
                    $isCripto = true;
                }
                
                $db->autocommit(FALSE);
                
                if($isCripto && !$isFiat){
                    $apiKeySecret = '';
                    $txidWallet = '';
                    //Si interface = 5, generamos la wallet con la api de la TCV
                    if(intval($currencydata['interface']) == 5){
                        $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                        
                        //Si el address es null o la respuesta distinta a 201, error
                        if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                            badEnd("402", array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                        }
                        
                        $walletid = $rsp['address'];
                        $apiKeySecret = randomString(8);
                    }elseif(intval($currencydata['interface']) == 4){
                        $parms = array("label"=>"afxaddr");
                        $request = array('method'=>'getnewaddress','parms' => $parms);
                        $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
            
                        // Validamos que el error no sea nulo para mandar el mensaje
                        if($rsp['error'] != null){
                            badEnd('500',array("msg"=>$rest['error']['message']));
                        }
                        
                        if($rsp['result'] == null){
                            badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                        }
                        
                        $walletid = $rsp['result'];
                        $apiKeySecret = randomString(8);
                    }else if(intval($currencydata['interface']) == 6){
                        //TETHER
                        $request = array('method'=>'createAddress');
                        //$request = array('method'=>'createAddress2','parms' => $parms); //testing width trx transaction
                        $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
        
                        if($rest['newaddress']['address_base58'] == null){
                            badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                        }
        
                        $walletid = $rest['newaddress']['address_base58'];
                        $apiKeySecret = $rest['newaddress']['private_key'];
        
                        $txidWallet = $rest['transaction']['txid'];
                    }else if (intval($currencydata['interface']) == 7){
                        // DASH
                        $parms = array("label"=>"afxaddr");
                        $request = array('method'=>'getnewaddress','parms' => $parms);
                        $rsp = json_decode(queryServicesDash($DASH_URL, $request),true);
        
                        // Validamos que el error no sea nulo para mandar el mensaje
                        if($rsp['error'] != null){
                            badEnd('500',array("msg"=>$rest['error']['message']));
                        }
                        
                        if($rsp['result'] == null){
                            badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                        }
                        
                        $walletid = $rsp['result'];
                        $apiKeySecret = randomString(8);
                    } else {
                        $walletid = randomString(30);
                        $apiKeySecret = randomString(8);
                    }
                
                    //Insertamos la nueva cuenta
                    $sql = "INSERT INTO accounts".
                    "       (".
                    "       paymentmethodid, ".
                    "       userid, ".
                    "       currencyid, ".
                    "       details1, ".
                    "       entityusrid, ".
                    "       status ".
                    "       )".
                    "       VALUES(".
                    "       -1, ".
                    "       ".$usriddest.", ".
                    "       ".$accountdata["accurrencyid"].", ".
                    "       '".$walletid."', ".
                    "       -1, ".
                    "       1 ".
                    "       )";
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error." 1 ".$sql));
                    }
                    
                    // Retornamos el id que fue insertado
                    $idcreated = (int)$db->insert_id;
                
                    //Al ser una cripto, creamos una wallet
                    $sql = "INSERT INTO wallets".
                    "       (".
                    "       wallet, ".
                    "       secretKey, ".
                    "       accountid, ".
                    "       txid, ".
                    "       expirationDate".
                    "       )".
                    "       VALUES(".
                    "       '".$walletid."', ".
                    "       '".$apiKeySecret."', ".
                    "       ".$idcreated.", ".
                    "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
                    "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                    "       )";
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error."2"));
                    }
                
                }else if($isFiat && !$isCripto){
                    //Insertamos la nueva cuenta
                    $sql = "INSERT INTO accounts".
                    "       (".
                    "       paymentmethodid, ".
                    "       userid, ".
                    "       currencyid, ".
                    "       entityusrid, ".
                    "       status".
                    "       )".
                    "       VALUES(".
                    "       -1, ".
                    "       ".$usriddest.", ".
                    "       ".$accountdata["accurrencyid"].", ".
                    "       -1, ".
                    "       1".
                    "       )";
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error."3"));
                    }
                }else{
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
                }
                
                $db->autocommit(TRUE);
                
                //Consultamos nuevamente los datos del usuario de destino
                $sql = "SELECT accounts.id AS accountid ".
                "       FROM accounts, users ".
                "       WHERE accounts.userid = users.id ".
                "       AND users.id = ".$usriddest.
                "       AND accounts.currencyid = ".$accountdata["accurrencyid"].
                "       AND accounts.paymentmethodid = -1";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $accountdestination = $rs->fetch_assoc();
            }
            
            //Obtenemos los datos del usuario de destino
            $sql = "SELECT users.id AS userid, ".
            "       users.usr AS userusr, ".
            "       users.type AS usertype, ".
            "       IF(userpersons.usrid IS NULL, usercompanies.phone, userpersons.phone) AS phone, ".
            "       userpersons.fname AS userpersonfname, ".
            "       userpersons.flastname AS userpersonflastname, ".
            "       usercompanies.name AS usercompanyname ".
            "       FROM users".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id".
            "       WHERE users.id = ".$usriddest;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
         
            $userdestinationdata = $rs->fetch_assoc();
            
            //Datos del destinatario
            if($userdestinationdata["usertype"] == 1){
                $nameAudit = $userdestinationdata["userpersonfname"].($userdestinationdata["userpersonflastname"] == "" ? "" : " ".$userdestinationdata["userpersonflastname"]);
            }else{
                $nameAudit = $userdestinationdata["usercompanyname"];
            }
        } else {
            // parametros obligatorios si existe en AFX pero es nivel 0 sin cuentas
            $parmsob = array('email','mobilephone', 'doctype', 'doc');
            if (!parametrosValidos($_GET, $parmsob)){
                badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
            }
            
            $usriddest = 0;
            $usriddestInserted = $userdesdata['id'];
            
            //Validamos el monto de las transacciones
            $sql = "SELECT SUM(t.amount) AS qty
                FROM transactions t, accounts
                WHERE t.accountid = accounts.id 
                AND accounts.id = ".$accountid."
                AND t.id = t.txid
                AND t.amount != 0
                AND t.dsc LIKE 'Transferencia PAY%'
                AND t.validator IS NULL ".
            "       AND MONTH(t.datecreated) = MONTH(NOW() AND YEAR(t.datecreated) = YEAR(NOW()))";
            if (!$res = $db->query($sql)){
                badEnd("500", array("msg"=>$db->error.$sql));
            }
            
            $movementData = $res->fetch_assoc();
            
            //Validamos si el monto total + monto operacion actual no excede el limite
            if((abs($movementData["qty"]) + $amount) >= $row["maxamountopsendpay"]){
                badEnd("403", array("msg"=>"Para aumentar su límite actual de operaciones inicie sesión en: <a href='".$applink."'>".$globname."</>"));
            }
            
            $hash = randomString(128);
            
            // obtenemos el usuario de la tabla users
            $sql = "SELECT IF(sessionid IS NULL, '".$hash."', sessionid) AS sessionid ".
            "       FROM users ".
            "       WHERE id = ".$userdesdata['id'];
            if (!$res=$db->query($sql)){
                badEnd("500", array("msg"=>$db->error.$sql));
            }
            
            $hashuser = $res->fetch_assoc();
            
            // Actualizamos el usuario
            $sql = "UPDATE users SET ".
            "       usr = '".strtolower($_GET['email'])."', ".
            "       sessionid = '".$hashuser['sessionid']."', ".
            "       paymobilephone = '".$_GET['mobilephone']."', ".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY)".
            "       WHERE id = ".$userdesdata['id'];
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
            $hash = $hashuser['sessionid'];
            $nameAudit = $_GET['email'];
            
            // Actualizamos el userpersons
            $sql = "UPDATE userpersons SET ".
            "       phone = '".$_GET['mobilephone']."', ".
            "       doctype = '".$_GET['doctype']."', ".
            "       doc = '".$_GET['doc']."' ".
            "       WHERE usrid = ".$userdesdata['id'];
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            // Validamos si existe en Pay
            $sql = "SELECT COUNT(userid) AS qty FROM payusers WHERE userid = ".$userdesdata['id'];
            if (!$res = $db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
            $userExistPay = $res->fetch_assoc();
            
            if ($userExistPay['qty'] > 0) {
                // Actualizamos el hash
                $sql = "UPDATE payusers SET ".
                "       sessionid = '".$hashuser['sessionid']."', ".
                "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY)".
                "       WHERE userid = ".$userdesdata['id'];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
            } else {
                // Insertamos el hash del registro en pay
                $sql = "INSERT INTO payusers(userid, sessionid, datecreated, validthru)".
                "       VALUES (".$userdesdata['id'].", ".
                "       '".$hashuser['sessionid']."', ".
                "       NOW(), ".
                "       DATE_ADD(NOW(), INTERVAL 1 DAY)".
                ")";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
            }
            
        }
    }
    
    $db->autocommit(FALSE);
    
    //insertamos la transferencia desde el origen
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Transferencia PAY a ".($usriddest == 0 ? $_GET['email'] : $userdesdata['usr'])."', ".
    "       ".$accountdata["accountid"].", ".
    "       ".$accountdata["accountid"].", ".
    "       0, ".
    "       -".$realamount.", ".
    "       ".($usriddest == 0 ? $usriddestInserted : $accountdestination["accountid"]).", ".
    "       NULL, ".
    "       NULL, ".
    "       ".($usriddest == 0 ? '1' : ($userdesdata["level"] == 0 ? '1' : '0')).
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."111","error"=>$sql));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    $out->id = $txid;
    
    //Le colocamos a la primera transferencia el txid
    $sql = "UPDATE transactions SET".
    "       txid= ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos el fee de la transferencia para el origen
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Transferencia PAY', ".
    "       ".$accountdata["accountid"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["accountid"].", ".
    "       -".$realfee.", ".
    "       0, ".
    "       ".$afxdata["id"].", ".
    "       NULL, ".
    "       NULL, ".
    "       ".($usriddest == 0 ? '1' : ($userdesdata["level"] == 0 ? '1' : '0')).
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."222"));
    }
    
    //insertamos el fee de la transferencia
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Transferencia PAY', ".
    "       ".$afxdata["id"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["accountid"].", ".
    "       0, ".
    "       ".$realfee.", ".
    "       ".$afxdata["id"].", ".
    "       NULL, ".
    "       NULL, ".
    "       ".($usriddest == 0 ? '1' : ($userdesdata["level"] == 0 ? '1' : '0')).
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."333"));
    }
        
        
    if ($usriddest != 0 && $levelDest != 0) {
        //insertamos la transferencia hacia el destino
        $sql = "INSERT INTO transactions".
        "       (".
        "       datecreated, ".
        "       dsc, ".
        "       accountid, ".
        "       txid, ".
        "       accountorigin, ".
        "       amountghost, ".
        "       amount, ".
        "       accountdestination, ".
        "       validator, ".
        "       validthru, ".
        "       paypending ".
        "       )".
        "       VALUES(".
        "       NOW(), ".
        "       'Transferencia PAY de ".$usrorigin."', ".
        "       ".$accountdestination["accountid"].", ".
        "       ".$txid.", ".
        "       ".$accountdata["accountid"].", ".
        "       0, ".
        "       ".$realamount.", ".
        "       ".$accountdestination["accountid"].", ".
        "       NULL, ".
        "       NULL, ".
        "       ".($usriddest == 0 ? '1' : ($userdesdata["level"] == 0 ? '1' : '0')).
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error."444".$sql));
        }
    }
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAuditByUserId($db, "OPERACIONES", $userid, "APP", "Se registró una transferencia por ".$amount." (".$out->id.") en ".$currencydata['name'].", del usuario ".$userdataaudit['name']." al usuario ".$nameAudit, $ipaddress);
    
    $out->account = new stdClass();
    $out->account->id = (int)$accountdata["accountid"];

    $db->commit();
    
    $db->autocommit(TRUE);
    
    // Obtenemos los datos del usuario de destino si no es 0
    if($usriddest != 0){
        $sql = "SELECT count(userid) AS qty ".
        "       FROM payusers ".
        "       WHERE userid = ".$usriddest;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userdesdataqty = $rs->fetch_assoc();
        
        if($userdesdataqty['qty'] == 0) {
            $hash = randomString(128);
            
            // Insertamos el hash del registro en pay
            $sql = "INSERT INTO payusers(userid, sessionid, datecreated, validthru)".
            "       VALUES (".$usriddest.", ".
            "       '".$hash."', ".
            "       NOW(), ".
            "       DATE_ADD(NOW(), INTERVAL 1 DAY)".
            ")";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            // Actualizamos tambien el hash en el user
            $sql = "UPDATE users SET ".
            "       sessionid = '".$hash."', ".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY) ".
            "       WHERE id = ".$usriddest;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
        } else {
            
            // Actualizamos el hash si nunca entrpo a crearse la cuenta
            // Validamos si tiene cuentas creadas de PAY
            $sql = "SELECT lastsession FROM payusers WHERE userid = ".$usriddest;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $payuser = $res->fetch_assoc();
            
            // Consultamos su nivel
            $sql = "SELECT level FROM users WHERE id = ".$usriddest;
            if (!$res=$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            $userlevel = $res->fetch_assoc();
            
            // Consultamos sus datos normales si es nivel 0 y no tiene movimientos pendientes
            $sql = "SELECT COUNT(transactions.id) AS qty ".
            "       FROM transactions ".
            "       LEFT JOIN  accounts ON accounts.id = transactions.accountdestination AND accounts.userid = ".$usriddest.
            "       WHERE transactions.paypending = 1 ".
            "       AND transactions.id = transactions.txid ".
            "       AND (transactions.accountdestination = ".$usriddest." OR accounts.id IS NOT NULL)";
            if (!$resxfer=$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            $transfers = $resxfer->fetch_assoc();
            
            if ($userlevel['level'] == 0 && $transfers['qty'] == 0 && $payuser['lastsession'] == null) {
                $userdesdataqty = array("qty"=>0);
            } else {
                $userdesdataqty = array("qty"=>1);
            }
            
        }
    } else {
        $userdesdataqty = array("qty"=>0);
    }

    $db->close();
    
    // Si el usuario es nuevo, debemos enviarle un sms y el correo de registro
    if($usriddest == 0 || $userdesdataqty['qty'] == 0){
        enviarSMS($_GET['mobilephone'], $userdataaudit['name']." le ha enviado ".number_format($realamount, $currencydata['decimals'],",",".")." ".$currencydata['symbol'].". Descárgate y regístrate en AFX Pay. https://cutt.ly/ATWqhKJ");
        
        $subject = "Únete a AFX PAY";
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = 
            "<div class='emailBox'>".
            "   <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/settings/img/logo-email.png'/>".
            "   <div class='mainBox'>".
            "       <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer_email.png'/>".
            "       <h1 class='goodText titleEmail'>".
            "           ".$userdataaudit['name']." le ha enviado ".$realamount." ".$currencydata['symbol'].
            "       </h1>".
            "       <p class='goodText msgEmail'>".
            "           Descarga nuestra aplicación móvil y completa el registro para comenzar a ser parte de la nueva economía digital.".
            "       </p>".
            "       <a class='urlNavigateBox' style='margin-bottom: 15px;' href='https://play.google.com/store/apps/details?id=la.totalsoftware.afxpay&hl=es&ah=U0XAMU0GFehZj3XHi8vdDyepZuw'>".
            "           <p style='margin: auto; display: block;color: #FFF;font-size: 16px;text-align:center;line-height: 58px;font-weight:bold;'>".
            "               Descarga la aplicación".
            "           </p>".
            "       </a>".
            "       <a class='urlNavigateBox' href=".$homeurl . "?id=register&sid=&hash=".$hash."&email=".($usriddest == 0 ? $nameAudit : $userdesdata['usr']).">".
            "           <p style='margin: auto; display: block;color: #FFF;font-size: 16px;text-align:center;line-height: 58px;font-weight:bold;'>".
            "               Regístrate".
            "           </p>".
            "       </a>".
            "   </div>".
            "   <p class='copy'>".$footerEmails."</p>".
            "</div>";
        
        $body = templateEmail($body, $STANDAR_STYLE_EMAIL);
    
        enviarCorreo2($fromeMail, strtolower($usriddest == 0 ? $_GET['email'] : $userdesdata['usr']), $subject, $body);
        
        $subject = "Transferencia AFX Pay";
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = "<html>".
                "   <head>".
                "       <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>".
                "       <title></title>".
                "       <link href='https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap' rel='stylesheet'>".
                "       <link href='https://fonts.googleapis.com/css2?family=Roboto&display=swap' rel='stylesheet'>".
                "       ".$STANDAR_STYLE_EMAIL.
                "   </head>".
                "   <body>".
                "       <div class='emailBox'>".
                "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/settings/img/logo-email.png'/>".
                "           <div class='mainBox'>".
                "               <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer_email.png'/>".
                "               <h1 class='goodText titleEmail'>".
                "                   Hola ".strtolower($userdata['usr']).
                "               </h1>".
                "               <p class='goodText msgEmail'>".
                "                   Se hizo una transferencia de fondos por ".$amount." ".$currencydata['symbol']." a ".strtolower($usriddest == 0 ? $_GET['email'] : $userdesdata['usr']).
                "               </p>".
                "           </div>".
                "           <p class='copy'>".$footerEmails."</p>".
                "       </div>".
                "   </body>".
                "</html>";
    
        enviarCorreo2($fromeMail, strtolower($userdata['usr']), $subject, $body);
    } else {
        
        $subject = "Transferencia AFX Pay";
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = "<html>".
                "   <head>".
                "       <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>".
                "       <title></title>".
                "       <link href='https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap' rel='stylesheet'>".
                "       <link href='https://fonts.googleapis.com/css2?family=Roboto&display=swap' rel='stylesheet'>".
                "       ".$STANDAR_STYLE_EMAIL.
                "   </head>".
                "   <body>".
                "       <div class='emailBox'>".
                "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/settings/img/logo-email.png'/>".
                "           <div class='mainBox'>".
                "               <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer_email.png'/>".
                "               <h1 class='goodText titleEmail'>".
                "                   Hola ".strtolower($userdata['usr']).
                "               </h1>".
                "               <p class='goodText msgEmail'>".
                "                   Se hizo una transferencia de fondos por ".$amount." ".$currencydata['symbol']." a ".$userdesdata['usr'].
                "               </p>".
                "           </div>".
                "           <p class='copy'>".$footerEmails."</p>".
                "       </div>".
                "   </body>".
                "</html>";
    
        enviarCorreo2($fromeMail, strtolower($userdata['usr']), $subject, $body);
        
        $subject = "Transferencia AFX Pay";
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = "<html>".
                "   <head>".
                "       <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>".
                "       <title></title>".
                "       <link href='https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap' rel='stylesheet'>".
                "       <link href='https://fonts.googleapis.com/css2?family=Roboto&display=swap' rel='stylesheet'>".
                "       ".$STANDAR_STYLE_EMAIL.
                "   </head>".
                "   <body>".
                "       <div class='emailBox'>".
                "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/settings//img/logo-email.png'/>".
                "           <div class='mainBox'>".
                "               <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer_email.png'/>".
                "               <h1 class='goodText titleEmail'>".
                "                   Hola ".strtolower($userdesdata['usr']).
                "               </h1>".
                "               <p class='goodText msgEmail'>".
                "                   Se recibió una transferencia de fondos por ".$realamount." ".$currencydata['symbol']." de ".$userdata['usr'].
                "               </p>".
                "           </div>".
                "           <p class='copy'>".$footerEmails."</p>".
                "       </div>".
                "   </body>".
                "</html>";
    
        enviarCorreo2($fromeMail, strtolower($userdesdata['usr']), $subject, $body);
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>