<?php
//pay/api/sendmoney/executepagomovil
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    
    date_default_timezone_set('Etc/UTC');
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('secretcode');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $secretcode = $_POST['secretcode'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer operaciones
    isLevelValid($db, $userid);
    /*
    // Buscamos si hay una transaccion con ese codigo
    //Consultamos los datos de la transaccion
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("402", array("msg"=>"Código invalido"));
    }
    
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM transactions ".
    "       WHERE validator = ".$secretcode.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("403", array("msg"=>"Código expirado"));
    }*/
    
    // Si llegamos aqui, buscamos la info de ese tx
    $sql = "SELECT txid, id ".
    "       FROM transactions ".
    "       WHERE txid = 665";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    $id = $txdata['txid'];
    
    // Buscamos los datos del pago movil
    $sql = "SELECT * ".
    "       FROM pagomovildetails ".
    "       WHERE transactionid = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $pagomovildata = $rs->fetch_assoc();
    
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = ".$pagomovildata['currencytx'];
     if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $currency = $rs->fetch_assoc();
    
    // Consultamos el listado de bancos
    $headers = array('Content-Type:application/json');
    $request = array();
    $rest = queryApiBP($BP_URL_QA, "pagos/c2p/bancos", $BP_VERSION, "GET", $headers, $request);
    
    if($rest['httpres'] != 200 && $rest['httpres'] != 201){
        switch($rest['httpres']){
            case 503:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'El servidor no puede atender temporalmente su petición',
                    "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petición")));
                break;
            default:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'Error llamada a API BP',
                    "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
        }
    }
    
    $banks = $rest['bancos'];
    
    $bankid = '';
    // recorremos los bancos para sacar el code a partir del nombre para la API
    foreach($banks as $bank){
        if ($bank['nombre'] == $pagomovildata['bankname']) {
            $bankid = $bank['codigo'];
        }
    }
    
    // Necesitamos
    $ci = $pagomovildata['docid'];
    $phone = $pagomovildata['phone'];
    $amount = $pagomovildata['amounttx'];
    
    $reference = '';
    
    if($rest['headerres']['codigorespuesta'] == '0084'){
        $reference = '0000';
        // QUITAR A004 CUANDO SE SOLUCIONE LO DE LA APIKEY
    }else /*if ($rest['headerres']['codigorespuesta'] === 'A004') {
        $reference = randomString(24);
    }else*/{
        $reference = $rest['bodyres']->numeroReferencia;
    }

    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "PAY", "Se registró un pago móvil por ".$amount." en ".$currency['name'].", del usuario ".$userdataaudit['name'], $ipaddress);
    
    // Retornamos la data
    $out->txid = $reference;
    $out->transaction = new stdClass();
    $out->transaction->id = $id;
    
    // Main ??
    $out->transaction->main = new stdClass();
    $out->transaction->main->currency = new stdClass();
    $out->transaction->main->currency->id = $currency['id'];
    $out->transaction->main->currency->symbol = $currency['symbol'];
    $out->transaction->main->currency->name = $currency['name'];

    $out->transaction->main->amount = new stdClass();
    $out->transaction->main->amount->number = (float)bcdiv(number_format($amount,13, '.', ''), '1',$row["currencydecimals"]);
    $out->transaction->main->amount->formatted = numberFormatt($out->transaction->main->amount->number,$currency["decimals"]);
    $out->test = $currency;
    
    // Destino
    $out->transaction->destination = new stdClass();
    $out->transaction->destination->c2pbank = new stdClass();
    $out->transaction->destination->c2pbank->code = $bankid;
    $out->transaction->destination->c2pbank->name = $pagomovildata['bankname'];
    $out->transaction->destination->mobilephone = $phone;
    $out->transaction->destination->docid = $ci;
    
    // origen
    $out->transaction->origin = new stdClass();
    $out->transaction->origin->c2pbank = new stdClass();
    $out->transaction->origin->c2pbank->name = $BP_NAME;
    $out->transaction->origin->mobilephone = $phoneAFX;
    $out->transaction->origin->docid = trim($rifafx, "-");
    
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function deleteTransactions($db, $txid, $lang, $msg = ""){
        //Abrimos la transaccion
        $db->autocommit(FALSE);

        //eliminar el retiro(si existe)
        $sql = "DELETE FROM withdrawals WHERE transactionid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //eliminar la transaccion
        $sql = "DELETE FROM transactions ".
        "       WHERE id = ".$txid.
        "       OR txid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //Retornamos 304 si no se elimino ningun registro
        if ($db->affected_rows == 0){
            $db->rollback();
            $db->close();   
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"No se pudo modificar",
                "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
        }
    
        $db->commit();
        $db->close();
            
        badEnd('500',array("msg"=>$msg == "" ? determinateDBError($db) : $msg));
    }
?>