<?php
// pay/api/transactions/ownuserxfer
    header("Content-Type:application/json");
    include_once("../../../settings/dbconn.php");
    include_once("../../../settings/utils.php");
    
    // parametros obligatorios
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $parmsob = array('oricurrid', 'descurrid', "qty");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $origincurrency = $_POST['oricurrid'];
    $descurrenty = $_POST['descurrid'];
    $out->order = new stdClass();
    $pairid = '';
    $type = 1;
    $side = 0;
    $price = 0;
    
    //Validamos la session
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Validamos el si el usuario puede hacer operaciones
    isLevelValid($db, $userid);
    
    //Obtenemos el lenguaje del usuario
    $lang = 'esp';
    
    // Obtenemos el par que usaremos
    $sql = "SELECT * ".
    "       FROM pairs ".
    "       WHERE ".
    "       (currencyid = ".$origincurrency.
    "           AND refcurrencyid = ".$descurrenty.
    "       ) OR ".
    "       (currencyid = ".$descurrenty.
    "           AND refcurrencyid = ".$origincurrency.
    "       )";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $pairdata = $rs->fetch_assoc();
    $pairid = $pairdata['id'];
    
    if ($pairdata['status'] == null || $pairdata['status'] == 0) {
        badEnd("404", array("msg" => "Par invalido"));
    } else {
        if ($pairdata['refcurrencyid'] == $origincurrency) {
            $side = 1;
        } else {
            $side = 2;
        }
    }
    
    // Consultamos la cantidad ingresada para formatearla y validarla
    $sql = "SELECT currencies.decimals AS decimals, ".
    "       currencies.id AS currencyid, ".
    "       currencies.name AS currencyname, ".
    "       currencies.symbol AS currencysymbol ".
    "       FROM currencies, pairs ".
    "       WHERE currencies.id = pairs.refcurrencyid ".
    "       AND pairs.id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $pairdata = $rs->fetch_assoc();
    
    $refcurrencydecimals = $pairdata['decimals'];
    
    $out->order->refcurrency = new stdClass();
    $out->order->refcurrency->id = (int)$pairdata['currencyid'];
    $out->order->refcurrency->name = $pairdata['currencyname'];
    $out->order->refcurrency->symbol = $pairdata['currencysymbol'];
    $out->order->refcurrency->decimals = (int)$pairdata['decimals'];
    
    //Obtenemos los decimales para el precio
    $sql = "SELECT currencies.decimals AS decimals, ".
    "       currencies.id AS currencyid, ".
    "       currencies.name AS currencyname, ".
    "       currencies.symbol AS currencysymbol ".
    "       FROM currencies, pairs ".
    "       WHERE currencies.id = pairs.currencyid ".
    "       AND pairs.id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $pairdata = $rs->fetch_assoc();
    
    $currencydecimals = $pairdata['decimals'];
    
    $out->order->basecurrency = new stdClass();
    $out->order->basecurrency->id = (int)$pairdata['currencyid'];
    $out->order->basecurrency->name = $pairdata['currencyname'];
    $out->order->basecurrency->symbol = $pairdata['currencysymbol'];
    $out->order->basecurrency->decimals = (int)$pairdata['decimals'];
    
    //Consultamos los datos del par
    $sql = "SELECT * FROM pairs WHERE id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $pairdata = $rs->fetch_assoc();
    
    $rate = new stdClass();
    $rate = determinateRate2($db, $pairdata["currencyid"], $pairdata["refcurrencyid"], 12);
    // Obtenemos la cantidad a cambiar
    
    if($side == 2){
        if ($rate->number == 0) {
            $qty = 0;
        } else {
            $qty = number_format($_POST["qty"] / $rate->number, $refcurrencydecimals, '.', '');
        }
        
    } else {
        $qty = $_POST["qty"];
    }
    
    // Consultamos los datos de el usuario
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $userdata = $res->fetch_assoc();
    
    // Validamos el monto minimo
    $sql = "SELECT minexchange ".
    "       FROM cmspreffees ".
    "       WHERE currencyid = ".$pairdata['refcurrencyid'].
    "       AND usertype = ".$userdata["type"].
    "       LIMIT 1";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $min = $res->fetch_assoc();
    
    if(validateMin($pairdata['refcurrencyid'],$userdata["type"], 4, $db, number_format($qty, $refcurrencydecimals, '.', ''))){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"Monto mínimo autorizado: ".numberFormatt($min['minexchange'], $refcurrencydecimals),
            "eng"=>"Minimum authorized amount: ".numberFormatt($min['minexchange'], $refcurrencydecimals)), $lang, "Monto mínimo autorizado: ".numberFormatt($min['minexchange'], $refcurrencydecimals))));
    }
    
    if(number_format($qty, $refcurrencydecimals, '.', '') == 0){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"La cantidad debe ser mayor a 0 - ".number_format($qty, $refcurrencydecimals, '.', ''),
            "eng"=>"The amount must be greater than 0 - ".number_format($qty, $refcurrencydecimals, '.', '')), $lang, "La cantidad debe ser mayor a 0 - ".number_format($qty, $refcurrencydecimals, '.', ''))));
    }
    
    validateBalance($userid, $db, $side, $pairdata, $qty, $price, $entityid);
    
    //Obtenemos los datos de la cuenta del usuario para account
    $sql = "SELECT * FROM accounts".
    "       WHERE userid = ".$userid.
    "       AND accounts.paymentmethodid = -1".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $accountdata = $rs->fetch_assoc();
    
    //Si el usuario posee una cuenta en la moneda de origen puede continuar
    //Si no se le genera una
    if($accountdata["id"] == null){
        
        // Obtenemos la moneda
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata["refcurrencyid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $currencydata = $res->fetch_assoc();
        
        //Validamos si es una criptomoneda o fiat
        $isCripto = false;
        $isFiat = false;
    
        if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 3 || intval($currencydata['interface']) == 2){
            $isFiat = true;
        }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6 || intval($currencydata['interface']) == 7){
            $isCripto = true;
        }
        
        $db->autocommit(FALSE);
        
        if($isCripto && !$isFiat){
            $apiKeySecret = '';
            $txidWallet = '';
            //Si interface = 5, generamos la wallet con la api de la TCV
            if(intval($currencydata['interface']) == 5){
                $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                
                //Si el address es null o la respuesta distinta a 201, error
                if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                    badEnd("402", array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['address'];
                $apiKeySecret = randomString(8);
            }elseif(intval($currencydata['interface']) == 4){
                $parms = array("label"=>"afxaddr");
                $request = array('method'=>'getnewaddress','parms' => $parms);
                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
    
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rsp['error'] != null){
                    badEnd('500',array("msg"=>$rest['error']['message']));
                }
                
                if($rsp['result'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['result'];
                $apiKeySecret = randomString(8);
            }else if(intval($currencydata['interface']) == 6){
                //TETHER
                $request = array('method'=>'createAddress');
                //$request = array('method'=>'createAddress2','parms' => $parms); //testing width trx transaction
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
    
                if($rest['newaddress']['address_base58'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                }
    
                $walletid = $rest['newaddress']['address_base58'];
                $apiKeySecret = $rest['newaddress']['private_key'];

                $txidWallet = $rest['transaction']['txid'];
            }else if (intval($currencydata['interface']) == 7){
                // DASH
                $parms = array("label"=>"afxaddr");
                $request = array('method'=>'getnewaddress','parms' => $parms);
                $rsp = json_decode(queryServicesDash($DASH_URL, $request),true);
    
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rsp['error'] != null){
                    badEnd('500',array("msg"=>$rest['error']['message']));
                }
                
                if($rsp['result'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['result'];
                $apiKeySecret = randomString(8);
            } else {
                $walletid = randomString(30);
                $apiKeySecret = randomString(8);
            }
        
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       details1, ".
            "       entityusrid, ".
            "       status ".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userid.", ".
            "       ".$pairdata["refcurrencyid"].", ".
            "       '".$walletid."', ".
            "       -1, ".
            "       1 ".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error." 1 ".$sql));
            }
                
            // Retornamos el id que fue insertado
            $idcreated = (int)$db->insert_id;
        
            //Al ser una cripto, creamos una wallet
            $sql = "INSERT INTO wallets".
            "       (".
            "       wallet, ".
            "       secretKey, ".
            "       accountid, ".
            "       txid, ".
            "       expirationDate".
            "       )".
            "       VALUES(".
            "       '".$walletid."', ".
            "       '".$apiKeySecret."', ".
            "       ".$idcreated.", ".
            "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
            "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."2"));
            }
        
        }else if($isFiat && !$isCripto){
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       entityusrid, ".
            "       status".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userid.", ".
            "       ".$pairdata["refcurrencyid"].", ".
            "       -1, ".
            "       1".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."3"));
            }
        }else{
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
        }
        
        $db->autocommit(TRUE);
        
        //Consultamos nuevamente los datos del usuario de destino
        $sql = "SELECT COUNT(accounts.id) AS qty FROM accounts".
        "       WHERE userid = ".$userid.
        "       AND accounts.paymentmethodid = -1".
        "       AND accounts.entityusrid = ".$entityid.
        "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $accountdata = $rs->fetch_assoc();
    }
    
    //Obtenemos los datos de la cuenta del usuario para paymentaccount
    $sql = "SELECT * FROM accounts".
    "       WHERE userid = ".$userid.
    "       AND accounts.paymentmethodid = -1".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = ".$pairdata["currencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db).$sql));
        
    $paymentaccountdata = $rs->fetch_assoc();
    
    //Si el usuario posee una cuenta en la moneda de origen puede continuar
    //Si no se le genera una
    if($paymentaccountdata["id"] == null){
        
        // Obtenemos la moneda
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata["currencyid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $currencydata = $res->fetch_assoc();
        
        //Validamos si es una criptomoneda o fiat
        $isCripto = false;
        $isFiat = false;
    
        if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 3 || intval($currencydata['interface']) == 2){
            $isFiat = true;
        }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6 || intval($currencydata['interface']) == 7){
            $isCripto = true;
        }
        
        $db->autocommit(FALSE);
        
        if($isCripto && !$isFiat){
            $apiKeySecret = '';
            $txidWallet = '';
            //Si interface = 5, generamos la wallet con la api de la TCV
            if(intval($currencydata['interface']) == 5){
                $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                
                //Si el address es null o la respuesta distinta a 201, error
                if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                    badEnd("402", array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['address'];
                $apiKeySecret = randomString(8);
            }elseif(intval($currencydata['interface']) == 4){
                $parms = array("label"=>"afxaddr");
                $request = array('method'=>'getnewaddress','parms' => $parms);
                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
    
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rsp['error'] != null){
                    badEnd('500',array("msg"=>$rest['error']['message']));
                }
                
                if($rsp['result'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['result'];
                $apiKeySecret = randomString(8);
            }else if(intval($currencydata['interface']) == 6){
                //TETHER
                $request = array('method'=>'createAddress');
                //$request = array('method'=>'createAddress2','parms' => $parms); //testing width trx transaction
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
    
                if($rest['newaddress']['address_base58'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                }
    
                $walletid = $rest['newaddress']['address_base58'];
                $apiKeySecret = $rest['newaddress']['private_key'];

                $txidWallet = $rest['transaction']['txid'];
            }else if (intval($currencydata['interface']) == 7){
                // DASH
                $parms = array("label"=>"afxaddr");
                $request = array('method'=>'getnewaddress','parms' => $parms);
                $rsp = json_decode(queryServicesDash($DASH_URL, $request),true);
    
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rsp['error'] != null){
                    badEnd('500',array("msg"=>$rest['error']['message']));
                }
                
                if($rsp['result'] == null){
                    badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                }
                
                $walletid = $rsp['result'];
                $apiKeySecret = randomString(8);
            } else {
                $walletid = randomString(30);
                $apiKeySecret = randomString(8);
            }
        
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       details1, ".
            "       entityusrid, ".
            "       status ".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userid.", ".
            "       ".$pairdata["currencyid"].", ".
            "       '".$walletid."', ".
            "       -1, ".
            "       1 ".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error." 1 ".$sql));
            }
                
            // Retornamos el id que fue insertado
            $idcreated = (int)$db->insert_id;
        
            //Al ser una cripto, creamos una wallet
            $sql = "INSERT INTO wallets".
            "       (".
            "       wallet, ".
            "       secretKey, ".
            "       accountid, ".
            "       txid, ".
            "       expirationDate".
            "       )".
            "       VALUES(".
            "       '".$walletid."', ".
            "       '".$apiKeySecret."', ".
            "       ".$idcreated.", ".
            "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
            "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."2"));
            }
        
        }else if($isFiat && !$isCripto){
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       entityusrid, ".
            "       status".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userid.", ".
            "       ".$pairdata["currencyid"].", ".
            "       -1, ".
            "       1".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."3"));
            }
        }else{
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
        }
        
        $db->autocommit(TRUE);
        
        $sql = "SELECT * FROM accounts".
        "       WHERE userid = ".$userid.
        "       AND accounts.paymentmethodid = -1".
        "       AND accounts.entityusrid = ".$entityid.
        "       AND accounts.currencyid = ".$pairdata["currencyid"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db).$sql));
            
        $paymentaccountdata = $rs->fetch_assoc();
    }
    
    //SI la operacion es del tipo market, consultamos la mejor oferta dependiendo de si es compra o venta
    if($side == 1 && $type == 1){
        
        //Consultamos que exista una venta
        $sql = "SELECT COUNT(o.id) as qty FROM orders o 
               WHERE o.side = 2 AND o.pairid = ".$pairid."
               AND (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                   AND ord.side = 2 ) >= ".$qty."
               AND (CASE 
                       WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        if($row['qty'] == 0){
            $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 2 ) as qty FROM orders o 
               WHERE o.side = 2 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo límite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
        }
        
        //Consultamos el mejor precio de venta
        $sql = "SELECT o.id, o.price FROM orders o ".
        "       WHERE o.side = 2 AND o.pairid = ".$pairid.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price DESC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $price = $row["price"];
        
        validateBalance($userid, $db, $side, $pairdata, $qty, $price, $entityid);
    }else if($side == 2 && $type == 1){
        // Consultamos que exista una venta
        $sql = "SELECT COUNT(o.id) as qty FROM orders o 
               WHERE o.side = 1 AND o.pairid = ".$pairid."
               AND (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                   AND ord.side = 1 ) >= ".$qty."
               AND (CASE 
                       WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        if($row['qty'] == 0){
            $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 1 ) as qty FROM orders o 
               WHERE o.side = 1 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo límite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
        }
        
        //Consultamos el mejor precio de compra
        $sql = "SELECT o.id, o.price FROM orders o".
        "       WHERE o.side = 1 AND o.pairid = ".$pairid.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price ASC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $price = $row["price"];
        validateBalance($userid, $db, $side, $pairdata, $qty, $price, $entityid);
    }
    
    //Insertamos la orden
    $db->autocommit(FALSE);
    
    $sql = "INSERT INTO orders ".
    "       ( pairid, ".
    "       quantity, side, ".
    "       type, price, ".
    "       total, ".
    "       date, accountid, ".
    "       paymentid, canceled )".
    "       VALUES (".
    "       ".$pairid.", ".
    "       ".number_format($qty, $refcurrencydecimals, '.', '').", ".$side.", ".
    "       ".$type.", ".number_format($price, $currencydecimals, '.', '').", ".
    "       ".number_format($qty * $price, $currencydecimals, '.', '').", ".
    "       NOW(), ".($side == 1 ? $accountdata['id'] : $paymentaccountdata['id']).", ".
    "       ".($side == 2 ? $accountdata['id'] : $paymentaccountdata['id']).", NULL".
    "       )";
    if (!$db->query($sql)){
        $error = determinateDBError($db);
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion de deposito
    $out->id = (int)$db->insert_id;
    $out->order->type = $side;
    
    //Si la orden es de tipo market tenemos que calcular el precio referencial
    if($type == 1){
        
        $sql = "SELECT o.id AS orderprinid, o.side AS orderprinside, ".
        "       o.type AS orderprintype, o.quantity AS orderprinqty, ".
        "       o.price AS orderprinprice, o.total AS orderprintotal, ".
        "       o.accountid AS orderprinaccount, o.paymentid AS orderprinpayment, ".
        "       o.pairid AS orderpair, ".
        "       pairs.refcurrencyid AS refcurrencyid, pairs.currencyid AS currencyid, ".
        "       IF( ".
        "          (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, ".
        "           (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), ".
        "           0 ) AS totallyprinfilled, ".
        "       users.id AS usridprin, users.level AS userlevelprin,  users.type AS usrtypeprin, ".
        "       ord.id AS ordersecid, ord.price AS ordersecprice, ord.quantity AS ordersecqty, ord.type AS ordersectype, ".
        "       ord.side AS ordersecside, ord.accountid AS ordersecaccount, ord.paymentid AS ordersecpayment, ".
        "       ord.total AS ordersectotal, ".
        "       IF( ".
        "          (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = ord.id ".
        "               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) IS NOT NULL, ".
        "           (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = ord.id ".
        "               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)), ".    
        "           0 ) AS totallysecfilled ".
        "       FROM users, accounts, pairs,orders o ".
        "           INNER JOIN orders ord ON ord.type = 1 AND o.side != ord.side AND o.pairid = ord.pairid ".
        "           AND (CASE ".
        "               WHEN ord.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = ord.id ".
        "                   AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity ".
        "                   AND ord.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       WHERE o.accountid = accounts.id ".
        "       AND accounts.userid = users.id ".
        "       AND pairs.id = o.pairid ".
        "       AND o.type = 2 ".
        "       AND ".
        "       (CASE ".
        "           WHEN o.canceled IS NOT NULL THEN -1 ".
        "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "               AND o.canceled IS NULL THEN 1 ".
        "           ELSE 0 ".
        "       END) = 0".
        "       ORDER BY ordersecid ASC, (CASE WHEN ord.side = 1 THEN orderprinprice END) DESC,".
        "      (CASE WHEN ord.side = 2 THEN orderprinprice END) ASC";
        if (!$rs=$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
            
        
        $orders = array();
        $currentOrder = [];
        while($row = $rs->fetch_assoc()){
            $records [] = $row;
            $qtytmp = 0;
            
            //Decimales de moneda base
            $sql = "SELECT decimals FROM currencies WHERE id = ".$row['currencyid'];
            if (!$res=$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
            
            $currencydecimals = $res->fetch_assoc();
            
            //Decimales moneda de ref
            $sql = "SELECT decimals FROM currencies WHERE id = ".$row['refcurrencyid'];
            if (!$res=$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
            
            $currencyrefdecimals = $res->fetch_assoc();
            
            //SI la orden PRIN no esta ingresada, la ingresamos
            if(!array_key_exists($row['orderprinid'], $orders)){
                $orders[$row['orderprinid']] = new stdClass();
                $orders[$row['orderprinid']]->id = (int)$row['orderprinid'];
                $prinfilled = ($row['totallyprinfilled']*100)/$row['orderprinqty'];
                
                $orders[$row['orderprinid']]->avaliable = number_format((($row['orderprinqty'] * (100 - $prinfilled))/100), $currencyrefdecimals['decimals'], '.', '');
                
                $orders[$row['orderprinid']]->price = number_format($row['orderprinprice'], $currencydecimals['decimals'], '.', '');
            }
            
            //SI la orden SEC no esta ingresada, la ingresamos
            if(!array_key_exists($row['ordersecid'], $orders)){
                $orders[$row['ordersecid']] = new stdClass();
                $orders[$row['ordersecid']]->id = (int)$row['ordersecid'];
                $secfilled = ($row['totallysecfilled']*100)/$row['ordersecqty'];
                
                $orders[$row['ordersecid']]->avaliable = number_format((($row['ordersecqty'] * (100 - $secfilled))/100), $currencyrefdecimals['decimals'], '.', '');
                
                $orders[$row['ordersecid']]->price = number_format($row['ordersecprice'], $currencydecimals['decimals'], '.', '');
            }
            
            //En este punto ya la orden esta ingresada, hacemos el intercambio (SIMULACION)
            
            //Validamos que las ordenes no se hayan completado
            
            if($orders[$row['ordersecid']]->avaliable <= 0 || $orders[$row['orderprinid']]->avaliable <= 0){
                continue;
            }
            
            //Con eso validamos que una sea completada en su totalidad y la otra de manera parcial
            if($orders[$row['orderprinid']]->avaliable < $orders[$row['ordersecid']]->avaliable){
                $qtytmp = $orders[$row['orderprinid']]->avaliable;
            }elseif($orders[$row['orderprinid']]->avaliable > $orders[$row['ordersecid']]->avaliable){
                $qtytmp = $orders[$row['ordersecid']]->avaliable;
            }else{
                $qtytmp = $orders[$row['orderprinid']]->avaliable;
            }
            
            //Si coincide hacemos la simulacion y la guardamos
            if($row['ordersecid'] == $out->id){
                $exchange = new stdClass();
                $exchange->quantity = $qtytmp;
                $exchange->price = $orders[$row['orderprinid']]->price;
                $exchange->decimals = $currencydecimals['decimals'];
                
                $currentOrder [] = $exchange;
                
                //resta de cantidad disponible de la orden market
                if($orders[$row['ordersecid']]->avaliable < $qtytmp){
                    $orders[$row['ordersecid']]->avaliable = number_format($qtytmp - $orders[$row['ordersecid']]->avaliable , $currencyrefdecimals['decimals'], '.', '');
                }else{
                    $orders[$row['ordersecid']]->avaliable = number_format($orders[$row['ordersecid']]->avaliable - $qtytmp, $currencyrefdecimals['decimals'], '.', '');
                }
                
                //Resta de la cantidad disponible en la orden limit
                if($orders[$row['orderprinid']]->avaliable < $qtytmp){
                    $orders[$row['orderprinid']]->avaliable = number_format($qtytmp - $orders[$row['orderprinid']]->avaliable , $currencyrefdecimals['decimals'], '.', '');
                }else{
                    $orders[$row['orderprinid']]->avaliable = number_format($orders[$row['orderprinid']]->avaliable - $qtytmp , $currencyrefdecimals['decimals'], '.', '');
                }
                
                //Luego de la simulacion, verificamos si la orden es 0 para romper el ciclo
                if($orders[$row['ordersecid']]->avaliable <= 0){
                    break;
                }
            }else{
                
                //resta de cantidad disponible de la orden market
                if($orders[$row['ordersecid']]->avaliable < $qtytmp){
                    $orders[$row['ordersecid']]->avaliable = number_format($qtytmp - $orders[$row['ordersecid']]->avaliable, $currencyrefdecimals['decimals'], '.', '');
                }else{
                    $orders[$row['ordersecid']]->avaliable = number_format($orders[$row['ordersecid']]->avaliable - $qtytmp, $currencyrefdecimals['decimals'], '.', '');
                }
                
                //Resta de la cantidad disponible en la orden limit
                if($orders[$row['orderprinid']]->avaliable < $qtytmp){
                    $orders[$row['orderprinid']]->avaliable = number_format($qtytmp - $orders[$row['orderprinid']]->avaliable, $currencyrefdecimals['decimals'], '.', '');
                }else{
                    $orders[$row['orderprinid']]->avaliable = number_format($orders[$row['orderprinid']]->avaliable - $qtytmp, $currencyrefdecimals['decimals'], '.', '');
                }
            }
        }
        
        $amountprices = 0;
        //Luego de que el ciclo se cumpla seguimos a mostrar el precio final
        foreach($currentOrder as $exchange){
            $pctparcial = 0;
            $pctparcial = ($exchange->quantity * 100) / $qty;
            
            $promprice = 0;
            $promprice = number_format((($pctparcial * $exchange->price) / 100), $exchange->decimals, '.', '');
                    
            //Sumamos los precios
            $amountprices += $promprice;
        }
        
        $out->finalprice = (float)$amountprices;
        
        validateBalance2($userid, $db, $side, $pairdata, $qty, $out->finalprice, $entityid);
    }
    
    //auditoria
    setAudit($db, "ORDENES", $sessionid, "APP", "Se creó la orden (".$out->id.")");
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function validateBalance($userid, $db, $side, $pairdata, $qty, $price){
        // Consultamos el lang del usuario
        $sql = "SELECT lang FROM users WHERE id - ".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $rs->fetch_assoc();
        $lang = $row['lang'];
        
        //Validar cantidad o monto dependiendo del side
        if($side == 1){
            //Al ser una venta, validamos que el usuario posea la cantidad indicada de la moneda ref del par
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
	        "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
	        "       AND accounts.paymentmethodid = -1".
	        "       AND accounts.entityusrid = -1 ".
	        "       AND transactions.paypending = 0".
	        "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(transactions.amount) - ABS(IF(( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1) IS NOT NULL,  ".
        	"               ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1), 0)".
            "       + IF(( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1) IS NOT NULL, ( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1),0) ".
        	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
        	"      ) as qty FROM transactions, accounts WHERE ".
        	"       transactions.accountid = accounts.id ".
        	"       AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid.
            "       AND transactions.paypending = 0";
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < $qty){
                badEnd('403', array('a'=>$roworders,'msg'=>determinateMsgFail(array(
                    "esp"=>'Cantidad insuficiente',
                    "eng"=>"Insufficient quantity"), $lang, 'Cantidad insuficiente')));
            }
        }else if($side == 2){
            //Al ser una compra, validamos que el usuario posea la cantidad*precio de la moneda base
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
	        "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
	        "       AND accounts.paymentmethodid = -1".
	        "       AND accounts.entityusrid = -1 ".
	        "       AND transactions.paypending = 0".
	        "       AND accounts.currencyid = ".$pairdata["currencyid"];
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(transactions.amount) - ABS(IF(( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1) IS NOT NULL,  ".
        	"               ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1), 0)".
            "       + IF(( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1) IS NOT NULL, ( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1),0) ".
        	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
        	"      ) as qty FROM transactions, accounts WHERE ".
        	"       transactions.accountid = accounts.id ".
        	"       AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid.
            "       AND transactions.paypending = 0";
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < ($price * $qty)){
                badEnd('403', array('msg'=>determinateMsgFail(array(
                    "esp"=>'Saldo insuficiente 22',
                    "eng"=>"Insufficient balance 22"), $lang, 'Saldo insuficiente 22')));
            }
        
        }else{
            
            badEnd('500',array('msg'=>'El parametro side debe ser 1(venta) o 2(compra)'));
        }
    }
    
    function validateBalance2($userid, $db, $side, $pairdata, $qty, $price){
        // Consultamos el lang del usuario
        $sql = "SELECT lang FROM users WHERE id - ".$userid;
        if (!$rs=$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
        
        $row = $rs->fetch_assoc();
        $lang = $row['lang'];
        
        //Validar cantidad o monto dependiendo del side
        if($side == 1){
            //Al ser una venta, validamos que el usuario posea la cantidad indicada de la moneda ref del par
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
            "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
            "       AND accounts.paymentmethodid = -1".
            "       AND accounts.entityusrid = -1 ".
            "       AND transactions.paypending = 0".
            "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
            if (!$rs=$db->query($sql)){
                $error = determinateDBError($db);
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(transactions.amount) - ABS(IF(( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1) IS NOT NULL,  ".
        	"               ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1), 0)".
            "       + IF(( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1) IS NOT NULL, ( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1),0) ".
        	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
        	"      ) as qty FROM transactions, accounts WHERE ".
        	"       transactions.accountid = accounts.id ".
        	"       AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid.
            "       AND transactions.paypending = 0";
    	        if (!$rs=$db->query($sql)){
                    $error = determinateDBError($db);
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error));
                }
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < $qty){
                $db->rollback();
                $db->close();
                badEnd('403', array('testing'=>$roworders, 'a'=>'aaaa','msg'=>determinateMsgFail(array(
                    "esp"=>'Cantidad insuficiente',
                    "eng"=>"Insufficient quantity"), $lang, 'Cantidad insuficiente')));
            }
        }else if($side == 2){
            //Al ser una compra, validamos que el usuario posea la cantidad*precio de la moneda base
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
	        "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
	        "       AND accounts.paymentmethodid = -1".
	        "       AND accounts.entityusrid = -1 ".
	        "       AND transactions.paypending = 0".
	        "       AND accounts.currencyid = ".$pairdata["currencyid"];
	        if (!$rs=$db->query($sql)){
                $error = determinateDBError($db);
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(transactions.amount) - ABS(IF(( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1) IS NOT NULL,  ".
        	"               ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders ".
            "           WHERE orders.canceled IS NULL ".
            "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
            "           AND accounts.userid = ".$userid.
            "           AND accounts.entityusrid = -1 AND accounts.paymentmethodid = -1  ".
        	"           AND orders.type != 1), 0)".
            "       + IF(( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1) IS NOT NULL, ( ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders ".
            "           WHERE orders.id = transactions.orderid 
                   AND accounts.id = transactions.accountid 
                    AND orders.canceled IS NULL 
                    AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid."
                    AND accounts.paymentmethodid = -1 
                    AND transactions.amount < 0 
                    AND accounts.entityusrid = -1
                    AND orders.type != 1),0) ".
        	"      + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
        	"           FROM transactions  ".
        	"           WHERE transactions.paypending = 1".
        "           AND accounts.id = transactions.accountid".
        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
        "           AND accounts.userid = ".$userid.
        "           AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
        	"      ) as qty FROM transactions, accounts WHERE ".
        	"       transactions.accountid = accounts.id ".
        	"       AND accounts.currencyid = ".$pairdata["refcurrencyid"]."
                    AND accounts.userid = ".$userid.
            "       AND transactions.paypending = 0";
	        if (!$rs=$db->query($sql)){
                $error = determinateDBError($db);
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < ($price * $qty)){
                $db->rollback();
            $db->close();
                badEnd('403', array('testing'=>'hola','msg'=>determinateMsgFail(array(
                    "esp"=>'Saldo insuficiente',
                    "eng"=>"Insufficient balance"), $lang, 'Saldo insuficiente')));
            }
        
        }else{
            $db->rollback();
            $db->close();
            badEnd('500',array('msg'=>'El parametro side debe ser 1(venta) o 2(compra)'));
        }
    }
    
    /*
     El calculo de tasa de conversión referencial será el precio ponderado
     de la ultima orden market si hubo una en las ultimas 4 horas en el
     par de monedas sino se tomarla del CMS Preferencias Tasas de cambio
     el valor correspondiente.
*/
function determinateRate2($db, $basecurrency, $seccurrency, $basedecimals){
    $rate = new stdClass();
    if ($seccurrency == $basecurrency) {
        $rate->number = (float)number_format(1, $basedecimals, '.', '');
        $rate->formatted = numberFormatt($recordnumber, $basedecimals);
    } else {
        //Si la moneda no es igual a la inicial debemos buscar si estan relacionadas en un par
        $sql = "SELECT COUNT(pairs.id) AS qty ".
        "       FROM pairs ".
        "       WHERE ".
        "       (currencyid = ".$seccurrency.
        "           AND refcurrencyid = ".$basecurrency.
        "       ) OR ".
        "       (currencyid = ".$basecurrency.
        "           AND refcurrencyid = ".$seccurrency.
        "       )";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $pairres = $res->fetch_assoc();
        
        //Si existe el par directo hacemos la conversion de balance
        if($pairres['qty'] > 0){
            
            $sql = "SELECT * FROM pairs WHERE ".
            "       (currencyid = ".$seccurrency.
            "           AND refcurrencyid = ".$basecurrency.
            "       ) OR ".
            "       (currencyid = ".$basecurrency.
            "           AND refcurrencyid = ".$seccurrency.
            "       )";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $pairres = $res->fetch_assoc();
            
            // Validamos que la ultima operacion es de las ultimas 4 horas, si no, obtenemos el otro rate
                
            //Obtenemos la ultima transaccion realizada
            $sql = "SELECT (SELECT ord.price FROM orders ord ".
            "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice ".
            "       FROM orders, accounts, transactions t  ".
            "           LEFT JOIN transactions txother ".
            "               ON t.orderid != txother.orderid ".
            "               AND t.txid = txother.txid  ".
            "               AND txother.amount > 0 ".
            "               AND txother.dsc NOT LIKE 'Comisi%' ".
            "       WHERE t.orderid IS NOT NULL ".
            "       AND orders.id = txother.orderid ".
            "       AND orders.pairid = ".$pairres['id'].
            "       AND t.id = t.txid ".
            "       AND t.dsc NOT LIKE 'Comisi%' ".
            "       AND accounts.id = orders.accountid ".
            "       GROUP BY t.txid ".
            "       ORDER BY t.datecreated DESC, t.id DESC".
            "       LIMIT 1";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                        
            $lastexchange = $res->fetch_assoc();
            
            // Si el movimiento no es nulo, hacemos el proceso de su calculo
            if($lastexchange['orderprice'] != null){
                if ($seccurrency == $pairres['currencyid']) {
                    $rate->number = bcdiv(number_format(1 / $lastexchange['orderprice'],13, '.', ''), '1',$basedecimals);
                } else {
                    $rate->number = bcdiv(number_format($lastexchange['orderprice'],13, '.', ''), '1',$basedecimals);
                }
                
                if ($rate->number == 0) {
                    if ($seccurrency == $pairres['currencyid']) {
                        $rate->number = bcdiv(number_format(1 / $lastexchange['orderprice'],13, '.', ''), '1',13);
                    } else {
                        $rate->number = bcdiv(number_format($lastexchange['orderprice'],13, '.', ''), '1',13);
                    }
                }
            }
                
            $rate->formatted = numberFormatt($rate->number, $basedecimals);
        }
    }
    
    return $rate;
}
?>