<?php
// app/api/partners/update
    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");

    // parametros obligatorios
    $parmsob = array("sessionid","id","name","doc","phone");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del GET
    $sessionid = $_GET["sessionid"];
    $partnerid = $_GET["id"];
    $name = $_GET["name"];
    $doc = $_GET["doc"];
    $phone = $_GET["phone"];
    $out = new stdClass;
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos los datos del usuario para saber si es juridico
    $sql = "SELECT id, usr, type FROM users WHERE sessionid='".$sessionid."'";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    $userdata = $rs->fetch_assoc();
    
    //Si el usuario es de otro tipo no puede agregar/actualizar socios
    if($userdata["type"] != 2){
        badEnd("400", array("msg"=>"Usuario no es tipo juridico"));
    }
    
    //Si el ID es igual a 0 agregamos un socio, si no, actualizamos en caso de que exista
    if($partnerid == 0){
        
        //Validamos que estos datos no han sido ingresados
        $sql = "SELECT * FROM usercompanypartners WHERE doc='".$doc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $partnerdata = $rs->fetch_assoc();
        
        //Si la consulta retona datos retornamos 409/registro duplicado
        if($partnerdata["id"] != null){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }
        
        //Si el flujo sigue se insertan los datos del nuevo socio
        $sql = "INSERT INTO usercompanypartners(".
        "       companyid, ".
        "       name, ".
        "       doc, ".
        "       ".validateFieldValues("legalrep","legalrep").
        "       ".validateFieldValues("politicalexp","politicallyexposed").
        "       ".validateFieldValues("affiliationbody","affiliationbody").
        "       ".validateFieldValues("positionheld","positionheld").
        "       ".validateFieldValues("pepcountryid","pepcountryid").
        "       ".validateFieldValues("peprelatedid","peprelatedid").
        "       phone)".
        "       VALUES ".
        "       (".$userdata["id"].", ".
        "       '".$name."', ".
        "       '".$doc."', ".
        "       ".validateFieldInsert("legalrep","number").
        "       ".validateFieldInsert("politicalexp","number").
        "       ".validateFieldInsert("affiliationbody","string").
        "       ".validateFieldInsert("positionheld","string").
        "       ".validateFieldInsert("pepcountryid","number").
        "       ".validateFieldInsert("peprelatedid","string").
        "       '".$phone."')";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $out->id = (int) $db->insert_id;
    }else{
        
        //Contamos los datos por los datos recibidos para validar que exista
        $sql = "SELECT COUNT(id) as qty FROM usercompanypartners".
        "       WHERE id !=".$partnerid." AND doc='".$doc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $res = $rs->fetch_assoc();
        
        if($res["qty"] > 0){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }
        
        //Actualizamos el socio
        $sql = "UPDATE usercompanypartners".
        "       SET".
        "       name='".$name."', ".
        "       doc='".$doc."', ".
        "       legalrep = ".($_GET["legalrep"] == "" ? "null" : $_GET["legalrep"]).", ".
        "       politicallyexposed = ".($_GET["politicalexp"] == "" ? "null" : $_GET["politicalexp"]).", ".
        "       affiliationbody = ".($_GET["affiliationbody"] == "" ? "null" : "'".$_GET["affiliationbody"]."'").", ".
        "       positionheld = ".($_GET["positionheld"] == "" ? "null" : "'".$_GET["positionheld"]."'").", ".
        "       pepcountryid = ".($_GET["pepcountryid"] == "" ? "null" : $_GET["pepcountryid"]).", ".
        "       peprelatedid = ".($_GET["peprelatedid"] == "" ? "''" : "'".$_GET["peprelatedid"]."'").", ".
        "       phone='".$phone."' ".
        "       WHERE id=".$partnerid;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $out->id = (int) $partnerid;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para validar que el parametro fue enviado.
    * Si el parametro existe retorna true y si no retorna false
    */
    function validateUpdate($param){
        $bolValues = false;
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $bolValues = true;
        }
        return $bolValues;
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo en el query, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando
    * $param == es el valor que se envia por la url
    */
    function validateFieldValues($param, $field){
        $strValues = "";
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $strValues .= " ".$field.",";
        }
        return $strValues;
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo a la base de datos, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando.
    * $type == El tipo de dato que es el campo a evaluar, Estos pueden ser:
    * -string
    * -date
    * -number
    */
    function validateFieldInsert($field,$type){
        $strInsert = "";
        
        if(isset($_GET[$field]) && $_GET[$field] != ""){
            if($type == "string" || $type == "date"){
                $strInsert .= " '".$_GET[$field]."',";
            }else if($type == "number"){
                if($field === "step"){
                    $strInsert .= " ".($_GET[$field] + 1).",";
                }else{
                    $strInsert .= " ".$_GET[$field].",";
                }
            }
        }
        
        return $strInsert;
    }
    
?>
