<?php
// app/api/users/updatecompany

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_POST["sessionid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos los datos del usuario para saber si necesitamos actualizar el type
    $sql = "SELECT id, usr, sessionid, type FROM users WHERE sessionid='".$sessionid."'";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error)); 
            
    $userdata = $rs->fetch_assoc();
    
    //Validamos que sea null para actualizar
    if($userdata["type"] == null){
        $sql = "UPDATE users".
        "       SET type=2".
        "       WHERE sessionid='".$sessionid."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    }else if($userdata["type"] == 1){
        //Cambio de tipo
        //Se elimina el de la otra tabla
        $sql = "DELETE FROM userpersons WHERE usrid='".$userdata["id"]."'";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error)); 
        
        //Se modifica el tipo de la tabla principal
        $sql = "UPDATE users".
        "       SET type=2".
        "       WHERE sessionid='".$sessionid."'";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //badEnd("304", array("msg"=>"No se pudo modificar"));
    }
    
    //Consultamos para saber si existe ya un perfil para la empresa
    $sql = "SELECT usrid FROM usercompanies WHERE usrid=".$userdata["id"];
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    $validconsult = $rs->fetch_assoc();
    
    /* Si el usuario no posee datos en userpersons insertamos un nuevo registro.
    *  En caso de que ya exista, se actualiza su informacion
    */
    if($validconsult["usrid"] == null){
        //Insertamos el usuario debido a que no cuenta con registro
        $sql = "INSERT INTO usercompanies(".validValues().")".
        "       VALUES (".createInsert($userdata["id"]).")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id =(int) $userdata["id"];
    }else{
        //Consultamos el usuario para verificar que existe el registro
        $sql = "SELECT usrid FROM usercompanies WHERE usrid=".$userdata["id"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["usrid"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro "));
        }
            
        //Actualizamos el usuario
        $sql = "UPDATE usercompanies".
        "       SET".
        "       ".createUpdate().
        "       WHERE usrid =".$userdata["id"];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        if ($db->affected_rows == 0){
            badEnd("304", array("msg"=>"No se pudo modificar"));
        }
            
        // Retornamos el id que fue insertado
        $out->id =(int) $userdata["id"];
    }
    
    //Creacion de carpeta(si no existe) y agrego de imagenes de verificacion
    if(isset($_POST["uploadids"]) && $_POST["uploadids"] != ""){
        //Creamos la direccion del folder
        $urlfolder = "../uploads/users/".$userdata["id"];
        
        //Creamos el directorio en caso de que no exista
        if(!is_dir($urlfolder)){
            mkdir($urlfolder, 0777, true);
        }
        
                
        $filesid = explode("-",$_POST["uploadids"]);
        
        $filesfromdir = glob($urlfolder.'/*');
        
        $arrlenstring = sizeof($filesid);
        
        $arrlendir = sizeof($filesfromdir);
        
        //Si no hay archivos significa que deben ser ingresados por primera vez
        if($arrlendir == 0){
            foreach($filesid as $fileid){
                //Recibimos el valor por el string que se envio en uploadids
                $fileuploaded = $_FILES[strval($fileid)];
                $ext = pathinfo($fileuploaded['name'], PATHINFO_EXTENSION);
                
                //Movemos el FILE del directorio temporal al del sistema para su uso
                if(move_uploaded_file($fileuploaded["tmp_name"], $urlfolder . "/" . $fileid . "." . $ext)){
                    //Guardamos los datos del FILE en la BD para su busqueda
                    $sql = "INSERT INTO useruploads(userid,prefuploadid,filetype,validated)".
                    "       VALUES(".$userdata["id"].",".$fileid.",'".$fileuploaded["type"]."',0)";
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                }
            }
        }else{
            //Recorremos todos los files para validar cuales existen en el string y cuales no
            foreach($filesfromdir as $filefromdir){
            
                $extfromdir = pathinfo($filefromdir, PATHINFO_EXTENSION);
                $filename = basename($filefromdir,".".$extfromdir);

                $fileinString = 0;
                for($i = 0; $i < $arrlenstring; $i++){
                    if($filename == $filesid[$i]){
                        $fileinString = 1;
                    }
                }
                
                /*  Si el fileinString es igual a 0 significa que el FILE no se encuentra 
                *   en el archivo y por ende se elimina del fichero y de la BD
                */
                if($fileinString == 0){
                    //Eliminamos registro
                    $sql = "DELETE FROM useruploads WHERE".
                    "       userid=".$userdata["id"]." AND".
                    "       prefuploadid = ".$filename;
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    
                    //Eliminamos fichero
                    unlink($filefromdir);
                
                }
            }
            
            //Recorremos nuevamente el array de string para validar si hay files nuevos para actualizar o ingresar
            foreach($filesid as $fileid){
                
                //Si el file fue enviado debe guardarse/actualizarse
                if(isset($_FILES[strval($fileid)])){
                    
                    //Si el archivo ya existia y quiere ser actualizado se elimina
                    $filewithsamename = glob($urlfolder . "/" . $fileid . ".*");
                    foreach ($filewithsamename as $file) {
                        unlink($file);
                    }
                    
                    $fileuploaded = $_FILES[strval($fileid)];
                    $ext = pathinfo($fileuploaded['name'], PATHINFO_EXTENSION);
                
                    //Movemos el FILE del directorio temporal al del sistema para su uso
                    if(move_uploaded_file($fileuploaded["tmp_name"], $urlfolder . "/" . $fileid . "." . $ext)){
                        
                        //Validamos que el registro en la BD
                        $sql = "SELECT userid, prefuploadid FROM useruploads".
                        "       WHERE userid = ".$userdata["id"]." AND".
                        "       prefuploadid = ".$fileid;
                        if (!$result=$db->query($sql))
                            badEnd("500", array("msg"=>$db->error));
                            
                        $imagedata = $result->fetch_assoc();
                        
                        //Si no existe, se inserta un nuevo registro
                        if($imagedata["userid"] == null){
                            $sql = "INSERT INTO useruploads(userid,prefuploadid,filetype,validated)".
                            "       VALUES(".$userdata["id"].",".$fileid.",'".$fileuploaded["type"]."',0)";
                            if (!$rs=$db->query($sql))
                                badEnd("500", array("msg"=>$db->error));
                        }else{
                            /*Si no, actualizamos el ya existente cambiando el type(si es necesario) y 
                            * colocamos el validated 0 para que el nuevo archivo sea validado
                            */
                            $sql = "UPDATE useruploads SET".
                            "       filetype = '".$fileuploaded["type"]."', ".
                            "       validated = 0".
                            "       WHERE".
                            "       userid = ".$userdata["id"]." AND".
                            "       prefuploadid = ".$fileid;
                            if (!$rs=$db->query($sql))
                                badEnd("500", array("msg"=>$db->error));
                        }
                    }
                }
            }
        }
    }else if(isset($_POST["uploadids"]) && $_POST["uploadids"] == ""){
        //Creamos la direccion del folder
        $urlfolder = "../uploads/users/".$userdata["id"];
        
        //Creamos el directorio en caso de que no exista
        if(!is_dir($urlfolder)){
            mkdir($urlfolder, 0777, true);
        }
        
        $filesfromdir = glob($urlfolder.'/*');
        
        //Recorremos todos los files para eliminarlo
        foreach($filesfromdir as $filefromdir){
            
            $extfromdir = pathinfo($filefromdir, PATHINFO_EXTENSION);
            $filename = basename($filefromdir,".".$extfromdir);
                
            //Eliminamos registro
            $sql = "DELETE FROM useruploads WHERE".
            "       userid=".$userdata["id"]." AND".
            "       prefuploadid = ".$filename;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                    
                    
            //Eliminamos fichero
            unlink($filefromdir);
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* UTILIDAD */
    function createUpdate(){
        $strQuery = "";
        $strQuery .= validateUpdate("venezuelan") ? " venezuelan = ".$_POST["venezuelan"]."," : "";
        $strQuery .= validateUpdate("companytype") ? " ctype = ".$_POST["companytype"]."," : "";
        $strQuery .= validateUpdate("name") ? " name = '".$_POST["name"]."'," : "";
        $strQuery .= validateUpdate("comercialname") ? " comercialname = '".$_POST["comercialname"]."'," : "";
        $strQuery .= validateUpdate("creationdate") ? " creationdate = '".$_POST["creationdate"]."'," : "";
        $strQuery .= validateUpdate("doc") ? " doc = '".$_POST["doc"]."'," : "";
        $strQuery .= validateUpdate("doccountryid") ? " doccountryid = ".$_POST["doccountryid"]."," : "";
        $strQuery .= validateUpdate("docregionid") ? " docregionid = ".$_POST["docregionid"]."," : "";
        $strQuery .= validateUpdate("doccityid") ? " doccityid = ".$_POST["doccityid"]."," : "";
        $strQuery .= validateUpdate("postalcode") ? " postalcode = '".$_POST["postalcode"]."'," : "";
        $strQuery .= validateUpdate("website") ? " website = '".$_POST["website"]."'," : "";
        $strQuery .= validateUpdate("partners") ? " partners = ".$_POST["partners"]."," : "";
        $strQuery .= validateUpdate("branchoffices") ? " branchoffices = ".$_POST["branchoffices"]."," : "";
        $strQuery .= validateUpdate("phone") ? " phone = ".$_POST["phone"]."," : "";
        $strQuery .= validateUpdate("countryid") ? " countryid = ".$_POST["countryid"]."," : "";
        $strQuery .= validateUpdate("stateid") ? " regionid = ".$_POST["stateid"]."," : "";
        $strQuery .= validateUpdate("cityid") ? " cityid = ".$_POST["cityid"]."," : "";
        $strQuery .= validateUpdate("street") ? " street = '".$_POST["street"]."'," : "";
        $strQuery .= validateUpdate("domicile") ? " domicile = '".$_POST["domicile"]."'," : "";
        $strQuery .= validateUpdate("economicact") ? " economicactivity = '".$_POST["economicact"]."'," : "";
        $strQuery .= validateUpdate("politicalexp") ? " politicallyexposed = ".$_POST["politicalexp"]."," : "";
        $strQuery .= validateUpdate("indepmerch") ? " independentdealer = ".$_POST["indepmerch"]."," : "";
        $strQuery .= validateUpdate("anualincome") ? " anualincome = '".$_POST["anualincome"]."'," : "";
        $strQuery .= validateUpdate("patrimony") ? " patrimony = '".$_POST["patrimony"]."'," : "";
        $strQuery .= validateUpdate("qtymonthlyop") ? " qtymonthlyop = '".$_POST["qtymonthlyop"]."'," : "";
        $strQuery .= validateUpdate("prefertypeop") ? " prefertypeop = '".$_POST["prefertypeop"]."'," : "";
        $strQuery .= validateUpdate("amomonthlyop") ? " amountmontlyop = '".$_POST["amomonthlyop"]."'," : "";
        $strQuery .= validateUpdate("economicrel") ? " economicrelation = ".$_POST["economicrel"]."," : "";
        $strQuery .= validateUpdate("step") ? " step = ".($_POST["step"] + 1)."," : "";
        $strQuery .= " lastupdate = NOW(),";
        
        return substr($strQuery, 0, -1);
    }
    
    /* Funcion para validar que el parametro fue enviado.
    * Si el parametro existe retorna true y si no retorna false
    */
    function validateUpdate($param){
        $bolValues = false;
        if(isset($_POST[$param])){
            $bolValues = true;
        }
        return $bolValues;
    }
    
    //Asignar campos a guardar
    function ValidValues(){
        $strValues = "";
        $strValues .= " usrid,";
        $strValues .= validateFieldValues("venezuelan","venezuelan");
        $strValues .= validateFieldValues("companytype","ctype");
        $strValues .= validateFieldValues("name","name");
        $strValues .= validateFieldValues("comercialname","comercialname");
        $strValues .= validateFieldValues("creationdate","creationdate");
        $strValues .= validateFieldValues("doc","doc");
        $strValues .= validateFieldValues("doccountryid","doccountryid");
        $strValues .= validateFieldValues("docregionid","docregionid");
        $strValues .= validateFieldValues("doccityid","doccityid");
        $strValues .= validateFieldValues("postalcode","postalcode");
        $strValues .= validateFieldValues("website","website");
        $strValues .= validateFieldValues("partners","partners");
        $strValues .= validateFieldValues("branchoffices","branchoffices");
        $strValues .= validateFieldValues("phone","phone");
        $strValues .= validateFieldValues("countryid","countryid");
        $strValues .= validateFieldValues("stateid","regionid");
        $strValues .= validateFieldValues("cityid","cityid");
        $strValues .= validateFieldValues("street","street");
        $strValues .= validateFieldValues("domicile","domicile");
        $strValues .= validateFieldValues("economicact","economicactivity");
        $strValues .= validateFieldValues("politicalexp","politicallyexposed");
        $strValues .= validateFieldValues("indepmerch","independentdealer");
        $strValues .= validateFieldValues("anualincome","anualincome");
        $strValues .= validateFieldValues("patrimony","patrimony");
        $strValues .= validateFieldValues("qtymonthlyop","qtymonthlyop");
        $strValues .= validateFieldValues("prefertypeop","prefertypeop");
        $strValues .= validateFieldValues("amomonthlyop","amountmontlyop");
        $strValues .= validateFieldValues("economicrel","economicrelation");
        $strValues .= validateFieldValues("step","step");
        $strValues .= " lastupdate,";
        
        return substr($strValues, 0, -1);
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo en el query, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando
    * $param == es el valor que se envia por la url
    */
    function validateFieldValues($param, $field){
        $strValues = "";
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            $strValues .= " ".$field.",";
        }
        return $strValues;
    }
    
    //Funcion para asignar campos al query
    function createInsert($usrid){
        $strQuery = "";
        $strQuery .= " ".$usrid.",";
        $strQuery .= validateFieldInsert("venezuelan","number");
        $strQuery .= validateFieldInsert("companytype","number");
        $strQuery .= validateFieldInsert("name","string");
        $strQuery .= validateFieldInsert("comercialname","string");
        $strQuery .= validateFieldInsert("creationdate","date");
        $strQuery .= validateFieldInsert("doc","string");
        $strQuery .= validateFieldInsert("doccountryid","number");
        $strQuery .= validateFieldInsert("docregionid","number");
        $strQuery .= validateFieldInsert("doccityid","number");
        $strQuery .= validateFieldInsert("postalcode","string");
        $strQuery .= validateFieldInsert("website","string");
        $strQuery .= validateFieldInsert("partners","number");
        $strQuery .= validateFieldInsert("branchoffices","number");
        $strQuery .= validateFieldInsert("phone","number");
        $strQuery .= validateFieldInsert("countryid","number");
        $strQuery .= validateFieldInsert("stateid","number");
        $strQuery .= validateFieldInsert("cityid","number");
        $strQuery .= validateFieldInsert("street","string");
        $strQuery .= validateFieldInsert("domicile","string");
        $strQuery .= validateFieldInsert("economicact","string");
        $strQuery .= validateFieldInsert("politicalexp","number");
        $strQuery .= validateFieldInsert("indepmerch","number");
        $strQuery .= validateFieldInsert("anualincome","string");
        $strQuery .= validateFieldInsert("patrimony","string");
        $strQuery .= validateFieldInsert("qtymonthlyop","string");
        $strQuery .= validateFieldInsert("prefertypeop","string");
        $strQuery .= validateFieldInsert("amomonthlyop","string");
        $strQuery .= validateFieldInsert("economicrel","number");
        $strQuery .= validateFieldInsert("step","number");
        $strQuery .= " NOW(),";
        
        return substr($strQuery, 0, -1);
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo a la base de datos, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando.
    * $type == El tipo de dato que es el campo a evaluar, Estos pueden ser:
    * -string
    * -date
    * -number
    */
    function validateFieldInsert($field,$type){
        $strInsert = "";
        
        if(isset($_POST[$field]) && $_POST[$field] != ""){
            if($type == "string" || $type == "date"){
                $strInsert .= " '".$_POST[$field]."',";
            }else if($type == "number"){
                if($field === "step"){
                    $strInsert .= " ".($_POST[$field] + 1).",";
                }else{
                    $strInsert .= " ".$_POST[$field].",";
                }
            }
        }
        
        return $strInsert;
    }
    
    function delete_directory($dirname) {
         if (is_dir($dirname))
           $dir_handle = opendir($dirname);
     if (!$dir_handle)
          return false;
     while($file = readdir($dir_handle)) {
           if ($file != "." && $file != "..") {
                if (!is_dir($dirname."/".$file))
                     unlink($dirname."/".$file);
                else
                     delete_directory($dirname.'/'.$file);
           }
     }
     closedir($dir_handle);
     rmdir($dirname);
     return true;
    }
?>
