<?php
// cms/api/appusers/levelslist

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","userid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["userid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos los datos del usuario para saber si existe
    $sql = "SELECT count(id) AS qty FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    if($row["qty"] == 0){
        badEnd("404",array("msg"=>"Usuario no encontrado"));
    }
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT COUNT(id) AS qty FROM levels";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Retornamos el resultado
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los registros a detalle
    $sql = "SELECT * FROM levels ORDER BY orden ASC";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    //Obtenemos los resultados para validar
    while($row = $rs->fetch_assoc()){
        //Declaramos una variabl
        $record = new stdClass();
        
        //Consultamos los datos del usuario para saber su tipo
        $sql = "SELECT id, usr, type FROM users WHERE id = ".$userid;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $user = $res->fetch_assoc();
        
        //Consultamos dependiendo del tipo de usuario junto su id
        if($user["type"] == 1){
            $sql = "SELECT *".
            "       FROM userpersons".
            "       WHERE usrid = ".$userid;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $userdetail = $res->fetch_assoc();
            $leveluser = $row["userpersons"];
        }else if($user["type"] == 2){
            $sql = "SELECT *".
            "       FROM usercompanies".
            "       WHERE usrid = ".$userid;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $userdetail = $res->fetch_assoc();
            $leveluser = $row["usercompanies"];
        }else{
            badEnd("304", array("msg"=>"Usuario no activado"));
        }
        
        
        //Validamos el nivel
        /* Hola buenas, si estas leyendo esto es por que probablemente sepas
        *   que dure 3 horas resolviendo un problema aqui,
        *   y si fue duro, hice pruebas, analice el codigo,
        *   cree otro ambiente aparte para solo depurar la funcion
        *   para luego de no encontrar el error, darme cuenta mientras le daba CTRL + Z
        *   que habia una variable que tenia una mayuscula entremita y que esa era la que me permitia validar
        *   :)))))
        */
        //Si no es valido no guardamos nada
        //Si lo es guardamos
        if(isLevelValid($leveluser, $userdetail["approved"], $row["cmsprefuploads"], $userid, $db, $user["type"])){
            if($user["type"] == 1){
                $record->id = (int)$row["id"];
                $record->name = $row["name"];
                //$record->test = isLevelValid($leveluser, $userdetail["approved"], $row["cmsprefuploads"], $userid, $db, $user["type"]);
                $records [] = $record;
            }else if($user["type"] == 2){
                if(isPartnersValid($row["usercompanypartners"], $db, $userid)){
                    $record->id = (int)$row["id"];
                    $record->name = $row["name"];
                    $records [] = $record;
                }else{
                    break;
                }
            }
        
        }else{
            break;
        }
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para validar si el nivel N esta disponible para el usuario
    *   Recibe seis parametros:
    *   $leveldata = requisitos del nivel y datos
    *   $levelimages = requisitos de imagenes
    *   $userid = id del usuario
    *   $userdetail = Datos del usuario
    *   $db = conexion a la base de datos
    *   $type = tipo de usuario
    */
    function isLevelValid($leveldata, $userdetail, $levelimages, $userid, $db, $type){
        //Datos opcionales (si, no entiendo que pasa)
        
        $isValidfield = true;
        $isValidimage = true;
        //Variable para validar si el campo existe/esta aprobado
        $fieldExist = false;
        
        //Creamos arreglos de la cadena separados por ,
        $fieldsrequired = explode(",",$leveldata);
        $fields = explode(",",$userdetail);
        //Creamos el arreglo de la cadena separado por -
        $imagesrequired = explode("-",$levelimages);
        
        //Obtenemos el length de cada arreglo
        $qtyfields = sizeof($fields);
        $qtyfieldsrequired = sizeof($fieldsrequired);
        $qtyimagesrequired = sizeof($imagesrequired);
        
        //Si el leveldata y levelimages estan vacios, significa que no hay datos que validar
        if($leveldata != "" && $levelimages != ""){
            //Recorres los campos requeridos 
            for($i = 0; $i < $qtyfieldsrequired; $i++){
                
                //en cada ciclo, inicializamos que el campo no existe
                $fieldExist = false;
                
                //Luego recorres los datos que posee el usuario para validar que este los tenga aprobados
                for($j = 0; $j < $qtyfields; $j++){
                    if(!empty($fields[$j])){
                        if(strpos($fieldsrequired[$i], $fields[$j]) !== false || $fieldsrequired[$i] == "declaration"){
                            //Si existe, rompemos el ciclo y colocamos que el campo existe
                            $fieldExist = true;
                            $j += $qtyfields;
                        }
                    }
                }
                
                //Si el campo no existe, significa que no puede validar para este nivel, rompemos el ciclo
                if(!$fieldExist){
                    $i += $qtyfieldsrequired;
                    $isValidfield = false;
                }
            }
            
            //Recorremos las imagenes requeridas
            for($i = 0; $i < $qtyimagesrequired; $i++){
                
                //en cada ciclo, inicializamos que el campo no existe
                $fieldExist = false;
                
                //Consultamos para saber si la imagen corresponde al tipo de usuario
                $sql = "SELECT ".
                "       IF(type LIKE '%".$type."%', 1, 0) AS validImg".
                "       FROM cmsprefuploads".
                "       WHERE id = ".$imagesrequired[$i];
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            
                $row = $rs->fetch_assoc();
                
                if($row["validImg"] == 1){
                    
                    //Luego consultamos la imagen para verificar si esta se encuentra validada
                    $sql = "SELECT validated ".
                    "       FROM useruploads WHERE ".
                    "       userid = ".$userid.
                    "       AND prefuploadid = ".$imagesrequired[$i];
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
            
                    $row = $rs->fetch_assoc();
                    
                    if($row["validated"] == 1){
                        //Si existe, colocamos que el campo existe
                        $fieldExist = true;
                    }
                }else{
                    $fieldExist = true;
                }
                
                //Si el campo no existe, significa que no puede validar para este nivel, rompemos el ciclo
                if(!$fieldExist){
                    $i += $qtyimagesrequired;
                    $isValidimage = false;
                }
            }
        }
        
        if($isValidimage && $isValidfield){
            return true;
        }else{
            return false;
        }
    }
    
    /*  Funcion para validar los datos de los socios
    *   Recibimos tres parametros
    *   fieldsrequired = campos requeridos para subir de nivel
    *   db = base de datos con
    *   userid = id del usuario
    */
    function isPartnersValid($fieldsrequired, $db, $userid){
        
        if($fieldsrequired == ""){
            return true;
        }else{
            $isValidfield = true;
            //Datos requeridos
            $fieldsrequiredarr = explode(",",$fieldsrequired);
            $qtyfieldsrequired = sizeof($fieldsrequiredarr);
            
            //Consultamos los datos de los socios
            $sql = "SELECT * from usercompanypartners".
            "       WHERE companyid = ".$userid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            while($row = $rs->fetch_assoc()){
                //Datos aprobados del usuario
                $fieldsapproved = explode(",",$row["approved"]);
                $qtyfieldsapproved = sizeof($fieldsapproved);
                
                if($row["approved"] != ""){
                    //Recorres los campos requeridos 
                    for($i = 0; $i < $qtyfieldsrequired; $i++){
                
                        //en cada ciclo, inicializamos que el campo no existe
                        $fieldExist = false;
                
                        //Luego recorres los datos que posee el usuario para validar que este los tenga aprobados
                        for($j = 0; $j < $qtyfieldsapproved; $j++){
                            if(!empty($fieldsapproved[$j])){
                                if($fieldsrequiredarr[$i] == "politicallyexposed" && $row["politicallyexposed"] == 0){
                                    $fieldExist = true;
                                    $j += $qtyfieldsapproved;
                                    $i += $qtyfieldsrequired;
                                }else if(strpos($fieldsrequiredarr[$i], $fieldsapproved[$j]) !== false){
                                    //Si existe, rompemos el ciclo y colocamos que el campo existe
                                    $fieldExist = true;
                                    $j += $qtyfieldsapproved;
                                }
                            }else{
                                $j += $qtyfieldsapproved;
                            }
                        }
                        
                        //Si el campo no existe, significa que no puede validar para este nivel, rompemos el ciclo
                        if(!$fieldExist){
                            $i += $qtyfieldsrequired;
                            $isValidfield = false;
                        }
                    }
                }
            }
            
            if($isValidfield){
                return true;
            }else{
                return false;
            }

        }
    }
    
    /*
    if($row["usercompanypartners"] == ""){
                        $out->nillego [] = "hola";
                    }else{
                        $isValidfield = true;
                        //Datos requeridos
                        $fieldsrequiredarr = explode(",",$row["usercompanypartners"]);
                        $qtyfieldsrequired = sizeof($fieldsrequiredarr);
                    
                        //Consultamos los datos de los socios
                        $sql = "SELECT * from usercompanypartners".
                        "       WHERE companyid = ".$userid;
                        if (!$res=$db->query($sql))
                            badEnd("500", array("msg"=>$db->error));
                
                        while($rowtest = $res->fetch_assoc()){
                            //Datos aprobados del usuario
                            $fieldsapproved = explode(",",$rowtest["approved"]);
                            $qtyfieldsapproved = sizeof($fieldsapproved);
                
                            if($rowtest["approved"] != ""){
                                //Recorres los campos requeridos 
                                for($i = 0; $i < $qtyfieldsrequired; $i++){
                
                                    //en cada ciclo, inicializamos que el campo no existe
                                    $fieldExist = false;
                
                                    //Luego recorres los datos que posee el usuario para validar que este los tenga aprobados
                                    for($j = 0; $j < $qtyfieldsapproved; $j++){
                                        if(!empty($fieldsapproved[$j])){
                                            if($fieldsrequiredarr[$i] == "politicallyexposed" && $rowtest["politicallyexposed"] == 0){
                                                $fieldExist = true;
                                                $j += $qtyfieldsapproved;
                                                $i += $qtyfieldsrequired;
                                            }else if(strpos($fieldsrequiredarr[$i], $fieldsapproved[$j]) !== false){
                                                //Si existe, rompemos el ciclo y colocamos que el campo existe
                                                $fieldExist = true;
                                                $j += $qtyfieldsapproved;
                                                $out->testing [] = $fieldsrequiredarr[$i]." - ".$fieldsapproved[$j].": ".$j;
                                            }
                                        }else{
                                            $j += $qtyfieldsapproved;
                                        }
                                    }
                        
                                    //Si el campo no existe, significa que no puede validar para este nivel, rompemos el ciclo
                                    if(!$fieldExist){
                                        $i += $qtyfieldsrequired;
                                        $isValidfield = false;
                                    }
                                }
                    
                                if($isValidfield){
                                    $out->simevalido[] = "hola";
                                }else{
                                    $out->quevabro[] = "hola";
                                }
                            }
                        }
                    }       
    */
?>
