<?php
// cms/api/appusers/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","level","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $level = $_GET["level"];
    $status = $_GET["status"];
    $tags = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 28))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamos para validar que exista el usuario
    $sql = "SELECT id, usr FROM users WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    //Si los tags son enviados, armamos el string
    if(isset($_GET["tags"]) && $_GET["tags"] != ""){
        $tagsarr = explode("-", $_GET["tags"]);
        $count = 0;
        //Por cada tag vamos creando la cadena, al primero no se le coloca el guion(-)
        foreach($tagsarr as $tag){
            if($count == 0){
                $tags .= "".$tag;
            }else{
                $tags .= "-".$tag;
            }
            $count++;
        }
    }
        
    //Actualizamos al usuario
    $sql = "UPDATE users SET ".
    "       level = ".$level.", ".
    "       status = ".$status.", ".
    "       ".($status == 1 ? " blockedthru = NULL " : " blockedthru = NOW() ").", ".
    "       risklevel = ".($_GET["risklevel"] == "" ? "NULL" : $_GET["risklevel"]).", ".
    "       tag = ".($tags != "" ? "'".$tags."'" : "NULL" )." ".
    "       WHERE id = ".$id;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se modifico el usuario ".$out->id);

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
