<?php
// cms/api/paymentmethods/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 22))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos los registros que necesitamos
    $sql = "SELECT * FROM paymentmethods".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    //Si el registro no existe retornamos 404
    if($row["id"] == null){
        badEnd("404", array("msg"=>"No encontrado"));
    }
    
    $out->entry = new stdClass();
    $out->entry->id = (int) $row["id"];
    $out->entry->dsc = $row["dsc"];
    
    //Estado del metodo
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
    
    //Pais del metodo de pago
    $out->entry->country = new stdClass();
    $sql = "SELECT id, name FROM countries WHERE id = ".$row["countryid"];
    if (!$countryres=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $rowcountry = $countryres->fetch_assoc();
    $out->entry->country->id = (int)$rowcountry["id"];
    $out->entry->country->dsc = $rowcountry["name"];
        
    $currencies = explode(",", $row["currencies"]);
    
    //Consultamos una a una de las monedas que administra
    foreach ($currencies as $curren){
        $sql = "SELECT * FROM currencies WHERE id = ".$curren;
        if (!$rescurren=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $rowcurren = $rescurren->fetch_assoc();
            
        $currendata = new stdClass();
        $currendata->id = (int)$rowcurren["id"];
        $currendata->dsc = $rowcurren["name"];
        $currendata->symbol = $rowcurren["symbol"];
            
        $currenciesarr [] = $currendata;
    }
        
    $out->entry->currencies = $currenciesarr;
        
    $out->entry->details1 = $row["details1"];
    $out->entry->details2 = $row["details2"];
    $out->entry->details3 = $row["details3"];
    $out->entry->details4 = $row["details4"];
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 19);
    $access->read =   tienePrivilegio($db, $sessionid, 22);
    $access->update = tienePrivilegio($db, $sessionid, 20);
    $access->delete = tienePrivilegio($db, $sessionid, 21);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
