<?php
// cms/api/roles/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id= $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 10))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos los registros que sean type = 1(roles)
    $sql = "SELECT * FROM cmsusers".
    "       WHERE type = 1 AND id = ".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    
    //Si el dato no existe retornamos 204
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["id"];
    $out->entry->name = $row["name"];
        
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 7);
    $access->read =   tienePrivilegio($db, $sessionid, 10);
    $access->update = tienePrivilegio($db, $sessionid, 8);
    $access->delete = tienePrivilegio($db, $sessionid, 9);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
