<?php 
    function getChart($db, $pairid, $timeframe){
        $chart = new stdClass();
        
        //Consultamos los datos requeridos
        $sql = "SELECT pairs.refcurrencyid AS pairsrefcurrency, ".
        "       currencies.name AS currencyname, currencies.symbol AS currencysymbol, ".
        "       currencies.id AS currencyid, pairs.id AS pairsid, ".
        "       currencies.decimals AS decimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.status = 1 AND ".
        "       pairs.id = ".$pairid." AND ".
        "       currencies.id = pairs.currencyid ".
        "       GROUP BY pairs.id";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
    
        $pairdata = $rs->fetch_assoc();
        
        // Obtenemos el nombre del par
        $sql = "SELECT CONCAT(currencies.symbol,'/',cursec.symbol) AS pairdsc, ".
        "       currencies.decimals AS currendecimals, cursec.decimals AS cursecdecimals".
        "       FROM currencies, pairs par ".
        "       LEFT JOIN currencies cursec ON cursec.id = par.currencyid ".
        "       WHERE par.refcurrencyid = currencies.id ".
        "       AND par.id = ".$pairid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        $currencyrefdecimals = (int)$row['currendecimals'];
        $currencydecimals = (int)$row['cursecdecimals'];
        
        $chart->pair = $row['pairdsc'];
        
        //Obtenemos el tipo de intervarlo y su equivalente en horas
        $chart->timeframe = determinateTimeframe($timeframe);
        $hour = convertTimeFrame($chart->timeframe);
        
        //Convertimos el timeframe a segundos
        $secondsHour = $hour * 3600;
        
        //Lines es el precio del ultimo CADA TIMEFRAME
        $chart->lines = new stdClass();
        
        $sql = "SELECT orders.id AS orderid, 
                orders.price AS orderprice, 
                t.txid AS txid,
                FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour.") AS label,
                CONCAT(HOUR(FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour.")),':00') AS reallabel,
                t.datecreated AS datecreated
                FROM orders, transactions t  
                    LEFT JOIN transactions txother 
                    ON t.orderid != txother.orderid 
                    AND t.txid = txother.txid
                WHERE orders.id = t.orderid
                AND orders.pairid = ".$pairid."
                AND orders.type = 2
                AND t.orderid IS NOT NULL
                AND t.txid = (SELECT MAX(txmax.txid)
                   	FROM transactions txmax, orders
                    WHERE 
                    FROM_UNIXTIME(
                        CEILING(UNIX_TIMESTAMP(txmax.datecreated)/".$secondsHour.")*".$secondsHour."
                    ) = FROM_UNIXTIME(
                        CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour."
                    ) 
                AND txmax.orderid = orders.id AND orders.pairid = ".$pairid.")
                GROUP BY label
            ORDER BY t.datecreated  DESC 
            LIMIT 60";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        while($row = $rs->fetch_assoc()){
            $record = new stdClass();
            
            
            $record->label = $row['reallabel'];
            $record->labeldetail = date("Y-m-d H:i:s", strtotime($row["label"]));
            
            $record->price = new stdClass();
            $record->price->number = (float)$row['orderprice'];
            $record->price->formatted = numberFormatt($row['orderprice'], $currencydecimals);
            
            $lines [] = $record;
        }
        
        $count = 0;
        $highestPrice = 0;
        foreach($lines as $i => $line){
            
            if($i == 0){
                $record = new stdClass();
                
                /*  1 = 1hora
                2 = 4 horas
                3 = 24 horas
                otro = 1 hora
                */
                if($chart->timeframe == 1){
                        
                    if(date('H', strtotime($line->labeldetail)) == '00'){
                        $record->label = date('d', strtotime($line->labeldetail));
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail))." ".date('H:i',strtotime($line->labeldetail));
                    }else{
                        $record->label = date('H', strtotime($line->labeldetail)).':00';
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail))." ".date('H:i',strtotime($line->labeldetail));
                    }
                    
                }else if($chart->timeframe == 2){
                    
                    if(date('H', strtotime($line->labeldetail)) == '00'){
                        $record->label = date('d', strtotime($line->labeldetail));
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail))." ".date('H:i',strtotime($line->labeldetail));
                    }else{
                        $record->label = date('H', strtotime($line->labeldetail)).':00';
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail))." ".date('H:i',strtotime($line->labeldetail));
                    }
                        
                }else if($chart->timeframe == 3){
                    
                    if(date('d',strtotime($line->labeldetail)) == '01'){
                        $record->label = determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('d',strtotime($line->labeldetail));
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail));
                    }else{
                        $record->label = date('d',strtotime($line->labeldetail));
                        $record->labeldetail = date('d',strtotime($line->labeldetail))." ".determinateMonth(date('n',strtotime($line->labeldetail)))." ".date('Y',strtotime($line->labeldetail));
                    }
                    
                }
            
                $record->canonnical = $line->labeldetail;
                $record->price = new stdClass();
                $record->price->number = $line->price->number;
                $record->price->formatted = $line->price->formatted;
                
                $linestest [] = $record;
                $count++;
                if($line->price->number > $highestPrice){
                    $highestPrice = $line->price->number;
                }
            }else if($i != 0 && $count <= 60){
                //Guardamos la ultima hora
                $lastHour = $linestest[$count-1]->canonnical;
                do{
                    $record = new stdClass();
                    
                    //Restamos la hora segun el timeframe
                    $lastHour = date('Y-m-d H:i:s', strtotime($lastHour) - $secondsHour);
                    
                    if($chart->timeframe == 1){
                        
                        if(date('H', strtotime($lastHour)) == '00'){
                            $record->label = date('d', strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }else{
                            $record->label = date('H', strtotime($lastHour)).':00';
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }
                        
                    }else if($chart->timeframe == 2){
                        
                        if(date('H', strtotime($lastHour)) == '00'){
                            $record->label = date('d', strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }else{
                            $record->label = date('H', strtotime($lastHour)).':00';
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }
                        
                    }else if($chart->timeframe == 3){
                        
                        if(date('d',strtotime($lastHour)) == '01'){
                            $record->label = determinateMonth(date('n',strtotime($lastHour)))." ".date('d',strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour));
                        }else{
                            $record->label = date('d',strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour));
                        }
                        
                    }
                    
                    $record->canonnical = $lastHour;
                    
                    $record->price = new stdClass();
                    $record->price->number = $line->price->number;
                    $record->price->formatted = $line->price->formatted;
                    if($line->price->number > $highestPrice){
                        $highestPrice = $line->price->number;
                    }
                    
                    $linestest [] = $record;
                    $count++;
            
                }while($lastHour != $line->labeldetail && $count <= 60);
            }
        }
        
        $chart->lines->max = (float)$highestPrice;
        $chart->lines->records = $linestest;

        //bars es el volumen de intercambio CADA TIMEFRAME
        $chart->bars = new stdClass();
        
        $sql = "SELECT SUM(transactions.amount) AS volume, 
	            FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(transactions.datecreated)/".$secondsHour.")*".$secondsHour.") AS label,
	            CONCAT(HOUR(FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(transactions.datecreated)/".$secondsHour.")*".$secondsHour.")),':00') AS reallabel,
                transactions.datecreated 
            FROM orders, transactions, accounts
            WHERE orders.pairid = ".$pairid."
            AND accounts.id = IF(orders.side = 2, orders.paymentid, orders.accountid) 
            AND accounts.currencyid = ".$pairdata["pairsrefcurrency"]."
            AND accounts.id = transactions.accountid 
            AND transactions.amount > 0
            AND transactions.orderid = orders.id
            GROUP BY label
            ORDER BY transactions.datecreated DESC
            LIMIT 60";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Recogemos los valores de la BD
        while($row = $rs->fetch_assoc()){
            $record = new stdClass();

            $record->label = $row['reallabel'];
            $record->labeldetail = date("Y-m-d H:i:s", strtotime($row["label"]));
            $record->price = new stdClass();
            $record->price->number = $row['volume'];
            $record->price->formatted = numberFormatt($row['volume'], $currencyrefdecimals);
            
            $bars [] = $record;
        }
        
        
        //Armamos los valores de la grafica
        //Deben ser 60 valores
        $count = 0;
        $maxvalues = 60;
        $highestVol = 0;
        foreach($bars as $i => $bar){
            
            //SI es cero guardamos nuestro punto de partida
            if($i == 0){
                $record = new stdClass();
                
                /*  1 = 1hora
                2 = 4 horas
                3 = 24 horas
                otro = 1 hora
                */
                if($chart->timeframe == 1){
                        
                    if(date('H', strtotime($bar->labeldetail)) == '00'){
                        $record->label = date('d', strtotime($bar->labeldetail));
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail))." ".date('H:i',strtotime($bar->labeldetail));
                    }else{
                        $record->label = date('H', strtotime($bar->labeldetail)).':00';
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail))." ".date('H:i',strtotime($bar->labeldetail));
                    }
                    
                }else if($chart->timeframe == 2){
                    
                    if(date('H', strtotime($bar->labeldetail)) == '00'){
                        $record->label = date('d', strtotime($bar->labeldetail));
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail))." ".date('H:i',strtotime($bar->labeldetail));
                    }else{
                        $record->label = date('H', strtotime($bar->labeldetail)).':00';
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail))." ".date('H:i',strtotime($bar->labeldetail));
                    }
                        
                }else if($chart->timeframe == 3){
                    
                    if(date('d',strtotime($bar->labeldetail)) == '01'){
                        $record->label = determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('d',strtotime($bar->labeldetail));
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail));
                    }else{
                        $record->label = date('d',strtotime($bar->labeldetail));
                        $record->labeldetail = date('d',strtotime($bar->labeldetail))." ".determinateMonth(date('n',strtotime($bar->labeldetail)))." ".date('Y',strtotime($bar->labeldetail));
                    }
                    
                }
                
                $record->canonnical = $bar->labeldetail;
                
                $record->price = new stdClass();
                $record->price->number = $bar->price->number;
                $record->price->formatted = $bar->price->formatted;
                $barstest [] = $record;
                $count++;
                
                if($bar->price->number > $highestVol){
                    $highestVol = $bar->price->number;
                }
            
            }else if($i != 0 && $count <= $maxvalues){
                //Guardamos la ultima hora
                $lastHour = $barstest[$count-1]->canonnical;
                do{
                    $record = new stdClass();
                    
                    //Restamos la hora segun el timeframe
                    $lastHour = date('Y-m-d H:i:s', strtotime($lastHour) - $secondsHour);
                    
                    if($chart->timeframe == 1){
                        
                        if(date('H', strtotime($lastHour)) == '00'){
                            $record->label = date('d', strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }else{
                            $record->label = date('H', strtotime($lastHour)).':00';
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }
                        
                    }else if($chart->timeframe == 2){
                        
                        if(date('H', strtotime($lastHour)) == '00'){
                            $record->label = date('d', strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }else{
                            $record->label = date('H', strtotime($lastHour)).':00';
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour))." ".date('H:i',strtotime($lastHour));
                        }
                        
                    }else if($chart->timeframe == 3){
                        
                        if(date('d',strtotime($lastHour)) == '01'){
                            $record->label = determinateMonth(date('n',strtotime($lastHour)))." ".date('d',strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour));
                        }else{
                            $record->label = date('d',strtotime($lastHour));
                            $record->labeldetail = date('d',strtotime($lastHour))." ".determinateMonth(date('n',strtotime($lastHour)))." ".date('Y',strtotime($lastHour));
                        }
                        
                    }
                    
                    $record->canonnical = $lastHour;
                    
                    // SI no son iguales no hubo volumen ese dia/hora
                    if($lastHour != $bar->labeldetail){
                        $record->price = new stdClass();
                        $record->price->number = 0;
                        $record->price->formatted = numberFormatt(0, $currencyrefdecimals);
                    }else{
                        $record->price = new stdClass();
                        $record->price->number = $bar->price->number;
                        $record->price->formatted = $bar->price->formatted;
                        
                        if($bar->price->number > $highestVol){
                            $highestVol = $bar->price->number;
                        }
                    }
                    
                    $barstest [] = $record;
                    $count++;
                    
                }while($lastHour != $bar->labeldetail && $count <= $maxvalues);
            }
        }
        
        $chart->bars->max = (float)$highestVol;
        //$chart->bars->records = $bars;
        $chart->bars->records = $barstest;
        
        return $chart;
    }
    
    /* Funcion para determinar el timeframe de la grafica:
        1 = 1
        2 = 2
        3 = 3
        otro = 1 hora
    */
    function  determinateTimeframe($timeframe){
        $time = 0;
        
        switch($timeframe){
            case 1:
                $time = 1;
                break;
            case 2:
                $time = 2;
                break;
            case 3:
                $time = 3;
                break;
            default:
                $time = 1;
                break;
        }
        
        return $time;
    }
    
    /* Funcion para determinar el timeframe de la grafica:
        1 = 1hora
        2 = 4 horas
        3 = 24 horas
        otro = 1 hora
    */
    function convertTimeFrame($timeframe){
        $time = 0;
        
        switch($timeframe){
            case 1:
                $time = 1;
                break;
            case 2:
                $time = 4;
                break;
            case 3:
                $time = 24;
                break;
            default:
                $time = 1;
                break;
        }
        
        return $time;
    }
    
    function determinateMonth($mon){
        $str = '';
        
        switch($mon){
            case 1:
                $str = 'Ene';
                break;
            case 2:
                $str = 'Feb';
                break;
            case 3:
                $str = 'Mar';
                break;
            case 4:
                $str = 'Abr';
                break;
            case 5:
                $str = 'May';
                break;
            case 6:
                $str = 'Jun';
                break;
            case 7:
                $str = 'Jul';
                break;
            case 8:
                $str = 'Ago';
                break;
            case 9:
                $str = 'Sep';
                break;
            case 10:
                $str = 'Oct';
                break;
            case 11:
                $str = 'Nov';
                break;
            case 12:
                $str = 'Dic';
                break;
        }
        
        return $str;
    }
?>