<?php 
    //cms/api/pairs/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid"); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    $sql = "SELECT pairs.refcurrencyid AS pairsrefcurrency, ".
    "       currencies.name AS currencyname, currencies.symbol AS currencysymbol, ".
    "       currencies.icon AS currencyicon, ".
    "       currencies.id AS currencyid, pairs.id AS pairsid,".
    "       currencies.decimals AS currencydecimals ".
    "       FROM pairs, currencies ".
    "       WHERE pairs.status = 1 AND ".
    "       currencies.id = pairs.currencyid ".
    "       GROUP BY pairs.id".
    "       ORDER BY pairs.id ASC";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($pairdata = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int) $pairdata["pairsid"];
        
        //Datos de moneda currency
        $record->currency = new stdClass();
        $record->currency->id = (int)$pairdata["currencyid"];
        $record->currency->dsc = $pairdata["currencyname"];
        $record->currency->symbol = $pairdata["currencysymbol"];
        $record->currency->icon = $pairdata["currencyicon"];
        $record->currency->decimals = (int)$pairdata["currencydecimals"];
        
        //Datos de refcurrency
        $record->refcurrency = new stdClass();
        
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata["pairsrefcurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $res->fetch_assoc();
        
        $record->refcurrency->id = (int)$row["id"];
        $record->refcurrency->dsc = $row["name"];
        $record->refcurrency->symbol = $row["symbol"];
        $record->refcurrency->icon = $row["icon"];
        $record->refcurrency->decimals = (int)$row["decimals"];
        
        $record->dsc = $record->refcurrency->symbol .'/'.$record->currency->symbol;
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>