<?php
// api/users/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
        
    // parametros obligatorios
    $parmsob = array('usrid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $usrid = $_GET['usrid'];
    
    // Validamos la session
    isSessionValidAPI($db, $sessionid);
    
    // Consultamos la cantidad de registros(status = 1)
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM users ".
    "       WHERE id > 0 ".
    "       AND id = ".$usrid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Si es igual a 0, no existe el registro
    if($row["qty"] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Consultamos los detalles de los registros
    $sql = "SELECT * ".
    "       FROM users ".
    "       WHERE id > 0 ".
    "       AND id = ".$usrid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->entry = new stdClass();
    
    $out->entry->id = (int)$row['id'];
    $out->entry->usr = $row['usr'];
    $out->entry->datecreated = date('Y-m-d', strtotime($row['datecreated']));
    
    // Consultamos los nombres de el usuario
    $sql = "SELECT ".
    "       IF(userpersons.fname IS NULL, usercompanies.name, userpersons.fname) AS firstname, ".
    "       IF(userpersons.sname IS NULL, '',userpersons.sname) AS secondname, ".
    "       IF(userpersons.flastname IS NULL, usercompanies.comercialname, userpersons.flastname) AS firstlastname, ".
    "       IF(userpersons.slastname IS NULL, '', userpersons.slastname) AS secondlastname ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON users.id = userpersons.usrid ".
    "       LEFT JOIN usercompanies ON users.id = usercompanies.usrid ".
    "       WHERE id = ".$out->entry->id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $rowNames = $rs->fetch_assoc();
    
    if($row['type'] == 1){
        $out->entry->name = $rowNames['firstname'].( $rowNames['secondname'] == '' ? '' : ' '.$rowNames['secondname']);
        $out->entry->lastname = $rowNames['firstlastname'].( $rowNames['secondlastname'] == '' ? '' : ' '.$rowNames['secondlastname']);
        $out->entry->fullname = $out->entry->name." ".$out->entry->lastname;
    }else if($row['type'] == 2){
        $out->entry->name = $rowNames['firstname'];
        $out->entry->lastname = $rowNames['firstlastname'];
        $out->entry->fullname = $out->entry->name." / ".$out->entry->lastname;
    }else{
        $out->entry->name = '';
        $out->entry->lastname = '';
        $out->entry->fullname = '';
    }
    
    $out->entry->lastsession = new stdClass();
    $out->entry->lastsession->date = date('Y-m-d H:i:s',strtotime($row['lastsession']));
    $out->entry->lastsession->formatted = date('d/m/Y h:i a',strtotime($row['lastsession']));
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row['status'];
    $out->entry->status->dsc = $row['status'] == 1 ? 'Activo' : 'Inactivo';
    
    $out->entry->type = new stdClass();
    $out->entry->type->id = (int)$row['type'];
    $out->entry->type->dsc = determinateType($row['type']);
    
    $out->entry->level = new stdClass();
    $out->entry->level->id = (int)$row['level'];
    $out->entry->level->dsc = "Nivel ".$row['level'];
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function determinateType($type){
        $str = '';
        
        switch($type){
            case 0:
                $str = 'Indefinido';
                break;
            case 1:
                $str = 'Natural';
                break;
            case 2:
                $str = 'Jurídico';
                break;
        }
        
        return $str;
    }
    
?>