<?php
// api/pairs/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    // parametros obligatorios
    $parmsob = array('offset','numofrec');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrec'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidAPI($db, $sessionid);
    
    // Consultamos la cantidad de registros
    $sql = "SELECT COUNT(par.id) AS qty ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies curr ON par.refcurrencyid = curr.id".
    "       WHERE currencies.id = par.currencyid ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    // Retornamos la cantidad de registros
    $out->numofrecords = (int)$row['qty'];
    
    // Consultamos los registros a detalle
    $sql = "SELECT currencies.name AS currencyname, currencies.symbol AS currencysymbol, ".
    "       currencies.icon AS currencyicon, ".
    "       currencies.id AS currencyid, par.id AS pairsid,".
    "       currencies.decimals AS currencydecimals, ".
    "       curr.name AS currencyrefname, curr.symbol AS currencyrefsymbol, ".
    "       curr.icon AS currencyreficon, ".
    "       curr.id AS currencyrefid, curr.decimals AS currencyrefdecimals ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies curr ON par.refcurrencyid = curr.id".
    "       WHERE currencies.id = par.currencyid ".
    "       ".$filter.
    "       GROUP BY par.id".
    "       ".$order;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($pairdata = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int) $pairdata["pairsid"];
        
        //Obtenemos la ultima transaccion realizada
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS lastprice ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$record->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
                
        $row = $res->fetch_assoc();
            
        // Ultimo intercambio
        $record->last = new stdClass();
        $record->last->number = (float)$row["lastprice"];
        $record->last->formatted = number_format($record->last->number,$pairdata["currencydecimals"],",",".");
    
        //Obtenemos la cantidad total que se ha hecho
        $sql = "SELECT SUM(transactions.amount) AS transactionamount FROM orders, transactions, accounts".
        "       WHERE orders.pairid = ".$record->id.
        "       AND accounts.id = IF(orders.side = 2, orders.paymentid, orders.accountid) ".
        "       AND accounts.currencyid = ".$pairdata["currencyrefid"].
        "       AND accounts.id = transactions.accountid ".
        "       AND transactions.amount > 0".
        "       AND transactions.orderid = orders.id".
        "       AND transactions.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $res->fetch_assoc();
        
        // Volumen en 24 horas
        $record->volume = new stdClass();
        $record->volume->number = (float)$row['transactionamount'];
        $record->volume->formatted = number_format($record->volume->number,$pairdata["currencyrefdecimals"],",",".");
        
        //Consultamos la ultima transaccion hace 24horas
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS transactionamount ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$record->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       AND t.datecreated <= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $res->fetch_assoc();
        $record->change = new stdClass();
        
        if($record->last->number == 0){
            $record->change->number = 0;
            $record->change->formatted = number_format($record->change->number,2,",",".")."%";
        }else{
            if($row['transactionamount'] > 0){
                $record->change->number = (($record->last->number - $row['transactionamount'])*100)/$row['transactionamount'] ;
                $record->change->formatted = number_format($record->change->number,2,",",".")."%";
            }else{
                $record->change->number = 0;
                $record->change->formatted = number_format($record->change->number,2,",",".")."%";
            }
        }
        
        //Datos de moneda currency
        $record->basecurrency = new stdClass();
        $record->basecurrency->id = (int)$pairdata["currencyid"];
        $record->basecurrency->dsc = $pairdata["currencyname"];
        $record->basecurrency->symbol = $pairdata["currencysymbol"];
        $record->basecurrency->icon = $pairdata["currencyicon"];
        
        //Datos de refcurrency
        $record->refcurrency = new stdClass();
        $record->refcurrency->id = (int)$pairdata["currencyrefid"];
        $record->refcurrency->dsc = $pairdata["currencyrefname"];
        $record->refcurrency->symbol = $pairdata["currencyrefsymbol"];
        $record->refcurrency->icon = $pairdata["currencyreficon"];
        
        $record->dsc = $record->refcurrency->symbol .'/'.$record->currency->symbol;
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
