<?php ini_set("memory_limit","220M"); ?>
<?php
// app/api/markers/chart

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $time = determinateTime($_GET["time"]);
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    $sql = "SELECT * FROM pairs WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $out->eyeX = new stdClass();
    
    for($i = 0; $i <= $time; $i++){
        $record = new stdClass();
        
        //Formato de la fechas/labels
        if($time == (24 * 60)/5){
            $record->label = $i == 0 ? date('H:i') : date('H:i', strtotime($eyeXRecords[$i-1]->label) - 60*5);
        }else if($time == 7*((24 * 60)/30)){
            $record->label = $i == 0 ? date('D H:i') : date('D H:i', strtotime($eyeXRecords[$i-1]->label) - 60*30);
        }else if($time == 30){
            $savedDate = $i == 0 ? date("d M Y") : date("d M Y", strtotime("-1 day", strtotime($eyeXRecords[$i-1]->label)));
            $record->label = $savedDate;
        }
        
        $record->high = new stdClass();
        $record->high->number = rand(10000,11000)/1.1;
        $record->high->formatted = number_format($record->high->number,2,",",".");
        
        $record->low = new stdClass();
        $record->low->number = rand(8500,9000)/1.1;
        $record->low->formatted = number_format($record->low->number,2,",",".");
        
        $eyeXRecords [] = $record;

    }
    
    $out->eyeX->records = $eyeXRecords;
    
    $out->eyeY = new stdClass();
    $out->eyeY->max = new stdClass();
    
    $out->eyeY->max->number = rand(9500,11000)/1.1;
    $out->eyeY->max->formatted = number_format($out->max->number,2,",",".");
    
    for($i = 0; $i < $time; $i++){
        $record = new stdClass();

        $record->number = rand(9000,11000)/1.1;
        $record->formatted = number_format($record->number,2,",",".");

        
        $eyeYRecords [] = $record;

    }
    
    $out->eyeY->records = $eyeYRecords;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar la cantidad de resultados a partir del tiempo
    *   Esta funcion recibe un parametro:
    /*   1 = Agrupacion por 24 Horas
    *   2 = Agrupacion por 7 dias de la semana
    *   3 = Agrupacion por 30 dias del mes
    *   
    */
    function determinateTime($time){
        $orderres = "";
        
        switch($time){
            case 1:
                $orderres = (24 * 60)/5;
                break;
            case 2:
                $orderres = 7*((24 * 60)/30);
                break;
            case 3:
                $orderres = 30;
                break;
            default:
                $orderres = (24 * 60)/5;
                break;
        }
        
        return $orderres;
    }
?>