<?php
// app/api/messages/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('id',"sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    
    //Definimos las variables que usaremos y las inicializamos
    $out= new stdClass();
    $id = $_GET['id'];
    $sessionid = $_GET["sessionid"];
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValid($db, $sessionid);
        
    // Obtenemos los detalles de los mensajes
    $sql = "SELECT comunications.id AS id, ".
    "       comunications.message AS message, ".
    "       comunications.tags AS tags, ".
    "       comunications.userid AS userid, ".
    "       IF(userpersons.fname IS NULL, ".
    "           CONCAT(usercompanies.name, ".
    "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
    "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL, '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL, '', CONCAT(' ',userpersons.slastname)) )".
    "       )  AS name, ".
    "       (SELECT users.usr FROM users WHERE users.id = comunications.userid) AS usr, ".
    "       comunications.ref AS ref, ".
    "       comunications.type AS type, ".
    "       comunications.createddate AS datecreated, ".
    "       comunications.date AS date, ".
    "       comunications.sentdate AS sentdate, ".
    "       comunications.readed AS readed ".
    "       FROM comunications ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = comunications.userid ".
    "       LEFT JOIN userpersons ON userpersons.usrid = comunications.userid ".
    "       WHERE comunications.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->entry= new stdClass();
        
    $out->entry->id = (int)$row['id'];
    //$out->entry->row= $row;
    
    $out->entry->user = new stdClass();
        
    $out->entry->user->id = (int)$row['userid'];
    $out->entry->user->fullname = $row['name'];
    $out->entry->user->user = $row['usr'];
    
    if($row['readed'] == NULL || $row['readed'] == 'NULL'){
        $out->entry->readed = null;
    }else{
        $out->entry->readed = new stdClass();
        $out->entry->readed->date = $row['readed'];
        $out->entry->readed->formatted = date('d/m/Y - h:i a',strtotime($row['readed']));
    }
    
    $out->entry->message = $row['message'];
    
    $out->entry->ref = new stdClass();
    $out->entry->ref->dsc = $row['ref'];
    
    $out->entry->type = (int)$row['type'];
    
    $out->entry->tags = $row['tags'];
    
    $out->entry->datecreated = new stdClass();
    $out->entry->datecreated->date = $row['datecreated'];
    $out->entry->datecreated->formatted = date('d/m/Y - h:i a',strtotime($row['datecreated']));
    
    $out->entry->date = new stdClass();
    $out->entry->date->date = $row['date'];
    $out->entry->date->formatted = date('d/m/Y - h:i a',strtotime($row['date']));
    
    $out->entry->sentdate = new stdClass();
    $out->entry->sentdate->date = $row['sentdate'];
    $out->entry->sentdate->formatted = date('d/m/Y - h:i a',strtotime($row['sentdate']));
    
    // SI EL USRID ES IGUAL AL USUARIO ACTUAL Y READED IS NULL LO MARCAMOS
    if($out->entry->user->id == $userid && ($row['readed'] == NULL || $row['readed'] == 'NULL') && $row['type'] == 2){
        $sql = "UPDATE comunications SET ".
        "       readed = NOW() ".
        "       WHERE ref = '".$out->entry->ref->dsc."' ".
        "       AND userid = ".$userid.
        "       AND createddate = '".$out->entry->datecreated->date."'";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
