<?php
// app/api/transactions/accept

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","validator");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $validator = $_GET["validator"];
    $id = $_GET["id"];
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    //Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Consultamos los datos de la transaccion
    $sql = "SELECT * FROM transactions WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["validator"] != $validator){
        badEnd("402", array("msg"=>determinateMsgFail(array(
            "esp"=>"Código invalido",
            "eng"=>"Invalid code"), $lang, "Código invalido")));
    }
    
    // Validamos que el codigo no este vencido
    $sql = "SELECT COUNT(id) AS qty FROM transactions ".
    "       WHERE id = ".$id.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"Código expirado",
            "eng"=>"Code expired"), $lang, "Código expirado")));
    }
    
    //Consultamos para saber si es un retiro o no
    $sql = "SELECT ( ".
    "           SELECT COUNT(withdrawals.transactionid) FROM withdrawals ".
    "           WHERE withdrawals.transactionid = tx.id ".
    "       ) AS isWithdraw, ".
    "       ( ".
    "           SELECT COUNT(deposits.transactionid) FROM deposits ".
    "           WHERE deposits.transactionid = tx.id ".
    "       ) AS isDeposit ".
    "       FROM transactions tx ".
    "       WHERE tx.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    $isWithdraw = intval($row['isWithdraw']);
    
    //Si es un retiro, debemos consulta a las API de la moneda
    if(intval($row['isWithdraw']) == 1 && intval($row['isDeposit']) == 0){
    
        //Consultamos la moneda para hacer llamado a API
        $sql = "SELECT currencies.symbol AS symbol, ".
        "       currencies.name AS name, ".
        "       currencies.id AS id, ".
        "       currencies.interface AS interface, ".
        "       ABS(transactions.amountghost) AS amount, ".
        "       withdrawals.ref AS ref, ".
        "       withdrawals.paymentwallet AS wallet ".
        "       FROM currencies, accounts, transactions, withdrawals ".
        "       WHERE transactions.id = ".$id.
        "       AND transactions.accountid = accounts.id ".
        "       AND accounts.currencyid = currencies.id ".
        "       AND withdrawals.transactionid = transactions.id";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $currencydata = $rs->fetch_assoc();
        
        switch(intval($currencydata['interface'])){
            case 1:
                $ci = '';
                // Si es fiat validamos que sea un pago movil
                $sql = "SELECT COUNT(*) AS qty ".
                "       FROM transactions WHERE id = ".$id.
                "       AND dsc LIKE '%pago móvil%' ".
                "       AND (SELECT COUNT(*) AS qty FROM transactions WHERE txid = ".$id.") = 3";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $paymentMobile = $res->fetch_assoc();
                
                // SI es mayor a 0 podemos ejecutar la llamada
                if($paymentMobile['qty'] > 0){
                    // Obtenemos primero que datos debemos consultas
                    $sql = "SELECT type FROM users ".
                    "       WHERE id = ".$userid;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $uservalid = $rs->fetch_assoc();
                    
                    $ci = GetFormattedIdentification($db, $userid);
                    
                    // Validamos el length ci
                    if(strlen($ci) < 1 && strlen($ci) > 12){
                        badEnd("408",array("msg"=>determinateMsgFail(array(
                            "esp"=>"Cédula invalida",
                            "eng"=>"Invalid identification card"), $lang, "Cédula invalida")));
                    }
                    
                    // Obtenemos el telefono y el banco
                    $bankid = $currencydata['wallet'];
                    $phone = $currencydata['ref'];
                    
                    $nonce = generateNonce();
                    
                    // Llamamos a la api primerito
                    $request = array(
                        'banco'=>$bankid,
                        'idBeneficiario'=>$ci,
                        'telefono'=>$phone,
                        'monto'=>(float)number_format($currencydata['amount'], $currency['decimals'], '.', ''),
                        'motivo'=>'Retiro AFX',
                        'canal'=>'23',
                        'id-externo'=>$id
                    );
                    
                    $headers = array('Content-Type:application/json', 
                        "api-key: $BP_C2P_KEY", 
                        "api-signature: ".
                        (
                            generateApiSignature("/".$BP_VERSION_P2P."/pagos/p2p".$nonce.json_encode($request),$BP_C2P_KEY_SECRET)
                        ),
                        "nonce: ".$nonce,
                    );
                    
                    // obtenemos respuesta
                    $rest = queryApiBP($BP_URL_QA, "pagos/p2p", $BP_VERSION_P2P, "POST", $headers, $request);
                    
                    if(($rest['bodyres']->numeroReferencia == null || $rest['bodyres']->numeroReferencia == '') && $rest['httpres'] != 200 && $rest['httpres'] != 201
                        && $rest['headerres']['codigorespuesta'] != '0084' ){
                        $msg_esp = "";
                        $msg_eng = "";
                        
                        switch($rest['headerres']['codigorespuesta']){
                            case 'E028':
                                $msg_esp = "El código de operaciones ingresado es inválido. Por favor intente de nuevo";
                                $msg_eng = "The operations code is invalid. Please try again";
                                break;
                            case 'E010':
                                $msg_esp = "Monto no válido";
                                $msg_eng = "Invalid amount";
                                break;
                            case 'E012':
                                $msg_esp = "Teléfono no habilitado para pagar";
                                $msg_eng = "Phone not enabled to pay";
                                break;
                            case 'E013':
                                $msg_esp = "Excede cantidad de pagos diarios";
                                $msg_eng = "Exceeds amount of daily payments";
                                break;
                            case 'E014':
                                $msg_esp = "Excede monto total de pagos diarios";
                                $msg_eng = "Exceeds total amount of daily payments";
                                break;
                            case 'E015':
                                $msg_esp = "Excede monto máximo para un pago";
                                $msg_eng = "Exceeds maximum amount for a payment";
                                break;
                            case 'E016':
                                $msg_esp = "Excede cantidad de pagos diarios";
                                $msg_eng = "Exceeds amount of daily payments";
                                break;
                            case 'E017':
                                $msg_esp = "Excede monto total de pagos diarios";
                                $msg_eng = "Exceeds total amount of daily payments";
                                break;
                            case 'E018':
                                $msg_esp = "Error en número de banco";
                                $msg_eng = "Bank number error";
                                break;
                            case 'E021':
                                $msg_esp = "Teléfono receptor no registrado";
                                $msg_eng = "Receiving phone not registered";
                                break;
                            case 'E022':
                                $msg_esp = "Teléfono receptor no acepta pagos";
                                $msg_eng = "Receiving phone does not accept payments";
                                break;
                            case 'E023':
                                $msg_esp = "Identificación del beneficiario no coincide";
                                $msg_eng = "Beneficiary ID does not match";
                                break;
                            case 'E024':
                                $msg_esp = "Cliente bloqueado";
                                $msg_eng = "Client blocked";
                                break;
                            case 'E030':
                                $msg_esp = "Banco no activo en pago móvil";
                                $msg_eng = "Bank not active in mobile payment";
                                break;
                            case 'A001':
                                $msg_esp = "Firma digital inválida";
                                $msg_eng = "Invalid digital signature";
                                break;
                            case '0080':
                                $msg_esp = 'Autorizador / Red no disponible';
                                $msg_eng = 'Authorizing / Red not avaliable';
                                break;
                            case '0057':
                                $msg_esp = 'Movimiento negado por el Receptor';
                                $msg_eng = 'Movement denied by Receiver';
                                break;
                            default:
                                $msg_esp = $rest['headerres']['descripcioncliente'];
                                $msg_eng = $rest['headerres']['descripcioncliente'];
                        }
                        
                        //Abrimos la transaccion
                        $db->autocommit(FALSE);
                        
                        //eliminar el retiro(si existe)
                        $sql = "DELETE FROM withdrawals WHERE transactionid = ".$id;
                        if (!$db->query($sql)){
                            $error = $db->error;
                            $db->rollback();
                            $db->close();
                            badEnd("500", array("msg"=>$error));
                        }
                        
                        //eliminar la transaccion
                        $sql = "DELETE FROM transactions ".
                        "       WHERE id = ".$id.
                        "       OR txid = ".$id;
                        if (!$db->query($sql)){
                            $error = $db->error;
                            $db->rollback();
                            $db->close();
                            badEnd("500", array("msg"=>$error));
                        }
                        
                        //Retornamos 304 si no se elimino ningun registro
                        if ($db->affected_rows == 0){
                            $db->rollback();
                            $db->close();
                            badEnd("403", array("msg"=>determinateMsgFail(array(
                            "esp"=>"No se pudo modificar",
                            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
                        }
                        
                        $db->commit();
                        $db->close();
                        
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>$msg_esp,
                            "eng"=>$msg_eng), $lang, $msg_esp), 'test'=>$rest));
                    }
                    
                    $reference = '';
                    
                    if($rest['headerres']['codigorespuesta'] == '0084'){
                        $reference = '0000';
                    }else{
                        $reference = $rest['bodyres']->numeroReferencia;
                    }
                    
                    //Obtenemos el id del retiro en la tcv y lo guardamos en ref
                    $sql = "UPDATE withdrawals SET ".
                    "       ".(strpos($rest['headerres']['descripcionSistema'], '9191') !== false ? " filetype = '9191', " : '').
                    "       paymentref = '".$reference."', ".
                    "       valid = NOW() ".
                    "       WHERE transactionid = ".$id;
                    if (!$db->query($sql)){
                        badEnd("500", array("msg"=>$db->error));
                    }
                }
                break;
            case 5:
                //Si es 5, llamamos a la api del TCV para hacer un retiro
                $rsp = queryPrivate('withdraws/new', $TCV_JWT, $TCV_URL, $VERSION_API, false, [
                    'rid' => $currencydata['wallet'], 
                    'currency' => $currencydata['symbol'],
                    'amount' => $currencydata['amount']
                ]);
                
                $out->test = $rsp;
                
                //Si el id es nulo, tenemos un error ya que es nuestra guia
                if($rsp['id'] == null || $rsp['httpres'] != 201){
                    //Abrimos la transaccion
                    $db->autocommit(FALSE);
                    
                    //eliminar el retiro(si existe)
                    $sql = "DELETE FROM withdrawals WHERE transactionid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
                    
                    //eliminar la transaccion
                    $sql = "DELETE FROM transactions ".
                    "       WHERE id = ".$id.
                    "       OR txid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
                    
                    //Retornamos 304 si no se elimino ningun registro
                    if ($db->affected_rows == 0){
                        $db->rollback();
                        $db->close();
                        badEnd("403", array("msg"=>determinateMsgFail(array(
                        "esp"=>"No se pudo modificar",
                        "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
                    }
                    
                    $db->commit();
                    $db->close();
                    
                    badEnd('402',array('msg'=>determinateMsgFail(array(
                        "esp"=>'Error API ingreso de retiro '.$rsp['httpres'],
                        "eng"=>'Withdrawal income API error '.$rsp['httpres']), $lang, 'Error API ingreso de retiro '.$rsp['httpres']),
                    'error'=>$rsp));
                }
                
                //Llamamos a la api por cada retiro para verificar su estado y actualizar sus datos
                $rsp2 = queryPrivate('withdraws/'.$rsp['id'], $TCV_JWT, $TCV_URL, $VERSION_API, true);
                
                if($rsp2['httpres'] != 200){
                    //Abrimos la transaccion
                    $db->autocommit(FALSE);

                    //eliminar el retiro(si existe)
                    $sql = "DELETE FROM withdrawals WHERE transactionid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
    
                    //eliminar la transaccion
                    $sql = "DELETE FROM transactions ".
                    "       WHERE id = ".$id.
                    "       OR txid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
    
                    //Retornamos 304 si no se elimino ningun registro
                    if ($db->affected_rows == 0){
                        $db->rollback();
                        $db->close();
                        badEnd("403", array("msg"=>determinateMsgFail(array(
                        "esp"=>"No se pudo modificar",
                        "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
                    }
    
                    $db->commit();
                    $db->close();
                    
                    badEnd('402',array('msg'=>determinateMsgFail(array(
                        "esp"=>'Error API ingreso de retiro '.$rsp2['httpres'],
                        "eng"=>'Withdrawal income API error '.$rsp2['httpres']), $lang, 'Error API ingreso de retiro '.$rsp2['httpres']),
                    'error'=>$rsp2));
                }
                
                if($rsp2['fee'] > 0){
                    //Consultamos la cuenta que tiene la moneda del retiro de AFX
                    $sql = "SELECT * FROM accounts WHERE userid = -1".
                    "       AND currencyid = ".$currencydata["id"].
                    "       AND paymentmethodid = -2";
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    //Guardamos la data de la cuenta AFX
                    $afxdata = $res->fetch_assoc();
                    
                    //Obtenemos la cuenta de la tx
                    $sql = "SELECT accountid FROM transactions WHERE id = ".$id;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    //Guardamos la data de la cuenta AFX
                    $accountid = $res->fetch_assoc();
                    
                    // Insertamos un movimiento con el fee de la blockchain
                    $sql = "INSERT INTO transactions".
                    "       (".
                    "       datecreated, ".
                    "       dsc, ".
                    "       amount, ".
                    "       amountghost, ".
                    "       validthru, ".
                    "       accountid, ".
                    "       validator, ".
                    "       orderid, ".
                    "       txid, ".
                    "       accountorigin, ".
                    "       accountdestination".
                    "       )".
                    "       VALUES(".
                    "       NOW(), ".
                    "       'Comisión de Retiro', ".
                    "       -".abs($rsp2['fee']).", ".
                    "       0, ".
                    "       NULL, ".
                    "       ".$afxdata["id"].", NULL, ".
                    "       NULL, ".
                    "       ".$id.", ".
                    "       ".$accountid["accountid"].", ".
                    "       ".$afxdata["id"].
                    "       )";
                    if (!$db->query($sql)){
                        
                        //Abrimos la transaccion
                        $db->autocommit(FALSE);
    
                        //eliminar el retiro(si existe)
                        $sql = "DELETE FROM withdrawals WHERE transactionid = ".$id;
                        if (!$db->query($sql)){
                            $error = $db->error;
                            $db->rollback();
                            $db->close();
                            badEnd("500", array("msg"=>$error));
                        }
        
                        //eliminar la transaccion
                        $sql = "DELETE FROM transactions ".
                        "       WHERE id = ".$id.
                        "       OR txid = ".$id;
                        if (!$db->query($sql)){
                            $error = $db->error;
                            $db->rollback();
                            $db->close();
                            badEnd("500", array("msg"=>$error));
                        }
        
                        //Retornamos 304 si no se elimino ningun registro
                        if ($db->affected_rows == 0){
                            $db->rollback();
                            $db->close();
                            badEnd("403", array("msg"=>determinateMsgFail(array(
                            "esp"=>"No se pudo modificar",
                            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
                        }
        
                        $db->commit();
                        $db->close();
                        
                        $error = $db->error;
                        badEnd("500", array("msg"=>$error));
                    }
                }
                
                //Obtenemos el id del retiro en la tcv y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       ref = ".$rsp['id'].
                "       WHERE transactionid = ".$id;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>$db->error));
                }
                break;
            case 4:
                
                $parms = array('address'=>$currencydata['wallet'],'amount'=>$currencydata['amount'],"subtractfeefromamount"=>true,"replaceable"=>true);
                $request = array('method'=>'sendtoaddress','parms' => $parms);
                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
                
                //Consultamos la cuenta que tiene la moneda del retiro de AFX - PERMITE OMITIR AJUSTE DE SUMARLE LA COMISIÓN BLOCKCHAIN QUE NO ES GANANCIA
                $sql = "SELECT * FROM accounts WHERE userid = -1".
                "       AND currencyid = ".$currencydata["id"].
                "       AND paymentmethodid = -2";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                //Guardamos la data de la cuenta AFX
                $afxdata = $res->fetch_assoc();
                
                // SI error no es nulo, significa que hubo un error
                if($rsp['error'] != null){
                    // Acomodamos el retiro para borrarlo
                    
                    //Abrimos la transaccion
                    $db->autocommit(FALSE);

                    //eliminar el retiro(si existe)
                    $sql = "DELETE FROM withdrawals WHERE transactionid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
    
                    //eliminar la transaccion
                    $sql = "DELETE FROM transactions ".
                    "       WHERE id = ".$id.
                    "       OR txid = ".$id;
                    if (!$db->query($sql)){
                        $error = $db->error;
                        $db->rollback();
                        $db->close();
                        badEnd("500", array("msg"=>$error));
                    }
    
                    //Retornamos 304 si no se elimino ningun registro
                    if ($db->affected_rows == 0){
                        $db->rollback();
                        $db->close();   
                        badEnd("403", array("msg"=>determinateMsgFail(array(
                        "esp"=>"No se pudo modificar",
                        "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
                    }
    
                    $db->commit();
                    $db->close();
                    
                    badEnd('500',array("msg"=>determinateMsgFail(array(
                        "esp"=>"Error API ingreso de retiro ".$rsp['error']['message'],
                        "eng"=>"Withdrawal income API error ".$rsp['error']['message']), $lang, "Error API ingreso de retiro ".$rsp['error']['message'])));
                }
                
                // Consultamos el movimiento
                $parms = array('txid'=>$rsp['result']);
                $request = array('method'=>'gettransaction','parms' => $parms);
                $rest = json_decode(queryServicesBTC($BTC_URL, $request), true);
                
                
                //$out->entregadeultimahoraCOMOSIEMPRE = $rest['result']['fee'];
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*ABS(amountghost + ".$rest['result']['fee'].") ".
                "       WHERE txid=".$id.
                "       AND accountid <> ".$afxdata["id"]." ". //Agregado por javier, no se actualiza la ganancia de afx esta es solo el % (signos generaban falla de cálculo)
                "       AND dsc LIKE '%comision%'";
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>$db->error));
                }
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*(ABS(amountghost) - ABS(".$rest['result']['fee'].")) ".
                "       WHERE id=".$id;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>$db->error));
                }
                
                //Obtenemos el tx del retiro de BTC y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       amount = -1 * ABS(ABS(amount) - ABS(".$rest['result']['fee'].")), ".
                "       fee = fee + ".$rest['result']['fee'].", ".
                "       ref = '".$rsp['result']."'".
                "       WHERE transactionid = ".$id;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>$db->error));
                }
                
                break;
        }
    }
    
    //Actualizamos la transaccion
    $sql = "UPDATE transactions SET".
    "       amount = amount + amountghost, ".
    "       validthru = NULL, ".
    "       amountghost = 0, ".
    "       validator = NULL ".
    "       WHERE txid = ".$id.
    "       AND validthru > NOW()".
    "       AND validator = ".$validator;
    if (!$db->query($sql)){
        $error = $db->error;
        badEnd("500", array("msg"=>$error));
    }
    
    $out->id = (int)$id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>