<?php
// cms/api/appusers/update

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","level","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $level = $_GET["level"];
    $status = $_GET["status"];
    $tags = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid); 
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 28))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamos para validar que exista el usuario
    $sql = "SELECT id, usr, level FROM users WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    // Guardamos el nivel
    $lastlevel = $row['level'];
    
    //Si los tags son enviados, armamos el string
    if(isset($_GET["tags"]) && $_GET["tags"] != ""){
        $tagsarr = explode("-", $_GET["tags"]);
        $count = 0;
        //Por cada tag vamos creando la cadena, al primero no se le coloca el guion(-)
        foreach($tagsarr as $tag){
            if($count == 0){
                $tags .= "".$tag;
            }else{
                $tags .= "-".$tag;
            }
            $count++;
        }
    }
        
    //Actualizamos al usuario
    $sql = "UPDATE users SET ".
    "       level = ".$level.", ".
    "       status = ".$status.", ".
    "       fails = 0, ".
    "       ".($status == 1 ? " blockedthru = NULL " : " blockedthru = NOW() ").", ".
    "       risklevel = ".($_GET["risklevel"] == "" ? "NULL" : $_GET["risklevel"]).", ".
    "       tag = ".($tags != "" ? "'".$tags."'" : "NULL" )." ".
    "       WHERE id = ".$id;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT users.usr AS email, IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name, ".
    "       IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone, " .
    "       users.level AS level, users.lang AS lang ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdata = $rs->fetch_assoc();
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se modificó el usuario ".$userdata['name']);
    
    // Validamos si se cambio el nivel
    if($lastlevel < $level && $level > 1){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
        
        // Consultamos los datos del mensaje
        $sql = "SELECT * FROM cmsmessages WHERE id = 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $data = $rs->fetch_assoc();
        
        // Validamos que el usuario tenga las notificaciones activas
        $sql = "SELECT * FROM usermessages ".
        "       WHERE categoryid = ".$data['category'].
        "       AND usrid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userPref = $rs->fetch_assoc();
        
        if($userPref['email'] == null || $userPref['email'] == 1){
            $subject = $userdata['lang'] == 'esp' ? $data['name_esp'] : $data['name_eng'];
            $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
            $body = "       <div style='background-color: #F8F8FA;padding: 20px;'>".
                    "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurlCMS."/img/afx-logo-email.png'/>".
                    "           <div style='margin: auto; display: block;background-color: #FFF;border-radius: 22px;width: 60%;padding:30px;'>".
                    "               <h1 class='goodText' style='color:#474C58;text-align:center;font-size: 20px;font-weight: bold;'>".($userdata['lang'] == "esp" ? "Hola" : "Hello")." ".$userdata['name']."</h1>".
                    "               <p class='goodText' style='font-size: 18px;color: #474C58;text-align:center;margin-bottom:30px;margin-left:20px;margin-right:20px;'>".( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng'])."</p>".
                    "           </div>".
                    "           <p class='copy' style='margin-top:40px; color: #767E93;text-align:center;font-family: Roboto, sans-serif;font-weight: 400;font-size: 12px;'>".$footerEmails."</p>".
                    "       </div>";
                    
            enviarCorreo2($fromeMail, strtolower($userdata['email']), $subject, $body);
        }
        // Se valida la preferenca del mensaje y se env��a seg��n el idioma
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $msg = $userdata['lang'] == 'esp' ? $data['sms_esp'] : $data['sms_eng'];
            enviarSMS($userdata['phone'], $msg);
        }
        if($userPref['system'] == null || $userPref['system'] == 1){
            
            $email = '';
            $sms = '';
            
            // Si se envia por correo obtenemos el correo del usuario
            if($userPref['email'] == null || $userPref['email'] == 1){
                $sql = "SELECT usr ".
                "       FROM users ".
                "       WHERE id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                        
                $rowPrefCom = $resPref->fetch_assoc();
                
                $email = $rowPrefCom['usr'];
            }
            
            // SI se envia por sms, obtenemos el numero del usuario
            if($userPref['sms'] == null || $userPref['sms'] == 1){
                $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                "       FROM users ".
                "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                "       WHERE users.id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                    
                $rowPrefCom = $resPref->fetch_assoc();
                
                $sms = $rowPrefCom['phone'];
                
            }
            
            // Enviamos el mensaje por la mensajeria interna
            $msg =( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']);
            saveInternalMsg($db, $msg, $id, $email, $sms);
        }
    }else if($lastlevel < $level && $level == 1){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
        
        // Consultamos los datos del mensaje
        $sql = "SELECT * FROM cmsmessages WHERE id = 14";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $data = $rs->fetch_assoc();
        
        // Validamos que el usuario tenga las notificaciones activas
        $sql = "SELECT * FROM usermessages ".
        "       WHERE categoryid = ".$data['category'].
        "       AND usrid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userPref = $rs->fetch_assoc();
        
        if($userPref['email'] == null || $userPref['email'] == 1){
            $subject = $userdata['lang'] == 'esp' ? $data['name_esp'] : $data['name_eng'];
            $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
            $body = "       <div style='background-color: #F8F8FA;padding: 20px;'>".
                    "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurlCMS."/img/afx-logo-email.png'/>".
                    "           <div style='margin: auto; display: block;background-color: #FFF;border-radius: 22px;width: 60%;padding:30px;'>".
                    "               <h1 class='goodText' style='color:#474C58;text-align:center;font-size: 20px;font-weight: bold;'>".($userdata['lang'] == "esp" ? "Hola" : "Hello")." ".$userdata['name']."</h1>".
                    "               <p class='goodText' style='font-size: 18px;color: #474C58;text-align:center;margin-bottom:30px;margin-left:20px;margin-right:20px;'>".( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng'])."</p>".
                    "           </div>".
                    "           <p class='copy' style='margin-top:40px; color: #767E93;text-align:center;font-family: Roboto, sans-serif;font-weight: 400;font-size: 12px;'>".$footerEmails."</p>".
                    "       </div>";
                    
            enviarCorreo2($fromeMail, strtolower($userdata['email']), $subject, $body);
        }
        
        // Se valida la preferenca del mensaje y se env��a seg��n el idioma
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $msg = $userdata['lang'] == 'esp' ? $data['sms_esp'] : $data['sms_eng'];
            enviarSMS($userdata['phone'], $msg);
        }
        
        if($userPref['system'] == null || $userPref['system'] == 1){
            
            $email = '';
            $sms = '';
            
            // Si se envia por correo obtenemos el correo del usuario
            if($userPref['email'] == null || $userPref['email'] == 1){
                $sql = "SELECT usr ".
                "       FROM users ".
                "       WHERE id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                        
                $rowPrefCom = $resPref->fetch_assoc();
                
                $email = $rowPrefCom['usr'];
            }
            
            // SI se envia por sms, obtenemos el numero del usuario
            if($userPref['sms'] == null || $userPref['sms'] == 1){
                $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                "       FROM users ".
                "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                "       WHERE users.id = ".$id;
                if (!$resPref=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                    
                $rowPrefCom = $resPref->fetch_assoc();
                
                $sms = $rowPrefCom['phone'];
                
            }
                            
            // Enviamos el mensaje por la mensajeria interna
            $msg = ( $userdata['lang'] == 'esp' ? $data['dsc_esp'] : $data['dsc_eng']);
            saveInternalMsg($db, $msg, $id, $email, $sms);
        }
    }else if($lastlevel < $level){
        //auditoria
        setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se cambió el nivel del usuario ".$userdata['name']);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
