<?php
// cms/api/countries/update

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","dsc","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $name = $_GET["dsc"];
    $status = $_GET["status"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es igual a 0, se crea, si no se actualiza el pais
    if($id == 0){
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 44))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Validamos que no exista un pais con el mismo nombre
        $sql = 'SELECT COUNT(id) AS qty FROM countries WHERE name ="'.$name.'"';
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] > 0){
            badEnd("409", array("msg"=>"Registro duplicado"));
        }
        
        $sql = "INSERT INTO countries(name, status, created_at, updated_at)".
        "       VALUES ('".$name."', ".$status.", NOW(), NOW())";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "PAISES", $sessionid, "CMS", "Se agregó el país ".$name);
    }else{
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 45))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Validamos que no exista un pais con el mismo nombre
        $sql = 'SELECT COUNT(id) AS qty FROM countries '.
        '       WHERE name = "'.$name.'"'.
        '       AND id != '.$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] > 0){
            badEnd("409", array("msg"=>"Registro duplicado"));
        }
            
        //Consultamos para validar que el registro exista
        $sql = "SELECT COUNT(id) AS qty FROM countries WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE countries SET".
        "       name = '".$name."', ".
        "       status = ".$status.", ".
        "       updated_at = NOW()".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "PAISES", $sessionid, "CMS", "Se actualizó el país ".$name);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
