<?php
// cms/api/levels/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT COUNT(id) AS qty FROM levels";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Retornamos el resultado
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los registros a detalle
    $sql = "SELECT * FROM levels ORDER BY orden ASC";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Ordenamos los resultados
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->name = $row["name"];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
