WS_waitscreen = true;

window.onload = function(){
    
    // Window Load
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    
    // Go to Register Page
    document.getElementById('register').addEventListener("click", function(){
        gotoPage('register','register-term','')
    }); 
    
    // Hide or show a Password
    document.getElementById('icon-eye').addEventListener("click", function(){
        show('icon-eye')
    }); 
    
    // Login
    document.getElementById('login').addEventListener("click", function(){
        login();
    }); 
    
    // Recover
    document.getElementById('forgot').addEventListener("click", function(){
        gotoPage('recover','forgot','')
    });
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('user').value !== ''){
            noError('user','euser')
        }
        if (document.getElementById('password').value !== ''){
            noError('password','epassword')
        }
        if (document.getElementById('lan').value !== ''){
            noError('lan','elan')
        }
    }); 
    
    document.getElementById('user').addEventListener('keydown', (event) => focusE(event, 'password'));
    
    document.getElementById('password').addEventListener('keydown', (event) => focusE(event, 'login'));
    
    document.getElementById('lan').addEventListener("click", function(){
         if(document.getElementById('lan').value!=''){
             document.getElementById('lan').style.color="#262624 !important;"
         }
    }); 
    
    //Mostrar HTML cargado
    esconderHTML(false);
}

// Show or hide password with eye icon
function show(a) {
    var icon = document.getElementById(a);
    var passwordInput = document.getElementById('password');
    if (passwordInput.getAttribute('type') == "password") {
        icon.removeAttribute("class");
        icon.setAttribute("class","fas fa-eye");
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute("type","text");
    } else {
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute('type','password');
        icon.removeAttribute("class");
        icon.setAttribute("class","fas fa-eye-slash");
    }
}

// Service login/login
function login(){
    var user = document.getElementById('user');
    var pwd = document.getElementById('password');
    var lan = document.getElementById('lan');
    if ( user.value === "" || pwd.value === "" || lan.value==="" ){
        if ( user.value === "" ) {
            error('user','euser','Introduzca un usuario.');
        }
        if ( pwd.value === "" ){
            error('password','epassword','Introduzca una contraseña.');
        }   
        if ( lan.value === "" ){
            error('lan','elan','Seleccione idioma.');
        } 
        return;
    } else {
        var req = {
            "usr": user.value,
            "pwd": MD5(pwd.value)
        }
        callWS("GET", "login/login", req, response);
        
        function response(status, rsp){
            //console.log(JSON.parse(rsp));
            console.log(status)
            switch(status){
                case 200:
                    gotoPage('register','regC',{ 'sessionid': JSON.parse(rsp).sessionid })
                    break;
                case 400:
                    //document.getElementById('epassword').innerHTML = 'Error en la llamada del servicio.';
                    break;
                case 401:
                    error('password','epassword','Clave inválida.');
                    break;
                case 402:
                    document.getElementById('epassword').innerHTML = 'Hay un problema con su usuario. Por favor contactar a support@afx.freshdesk.com.';
                    break;
                case 403:
                    document.getElementById('epassword').innerHTML = 'Hemos detectado que existe otra conexión activa en este momento y por su seguridad no podemos permitir el ingreso. Le recordamos que solo puede mantener una sesión activa con su usuario de AFX, intente nuevamente en 3 minutos';
                    break;
                case 404:
                    document.getElementById('epassword').innerHTML = 'El usuario no se encuentra registrado.';
                    break;
                case 500:
                    document.getElementById('epassword').innerHTML = 'Error inteno.';
                    break;
                default:
                    document.getElementById('epassword').innerHTML = 'Error.';
                    break;
            }
        }   
    }
}