<?php
// cms/api/currencies/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("order","offset","numofrec","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $order = determinateOrder(intval($_GET["order"]));
    $offset = $_GET["offset"];
    $numofrec = $_GET["numofrec"];
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        // Iniciamos la cadena del query
        $filter = " WHERE ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            if($index == 0){
                $filter .= " name LIKE '".$el."%' ".
                "           OR symbol LIKE '".$el."' ".
                "           ".(!is_numeric($el) ? '' : " OR decimals = ".$el." ");
            }else{
                $filter .= " OR name LIKE '".$el."%' ".
                "           OR symbol LIKE '".$el."' ".
                "           ".(!is_numeric($el) ? '' : " OR decimals = ".$el." ");
            }
        }
        
        $filter .= " ) ";
        
    }
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(id) AS qty".
    "       FROM currencies".
    "       ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los valores
    $sql = "SELECT * FROM currencies".
    "       ".$filter.
    "       ORDER BY ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->name = $row["name"];
        $record->symbol = $row["symbol"];
        $record->icon = $row["icon"];
        $record->decimals = (int)$row["decimals"];
        $record->interface = (int)$row['interface'];
        
        $record->status = new stdClass();
        $record->status->id = (int)$row["status"];
        $record->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 11);
    $access->read =   tienePrivilegio($db, $sessionid, 14);
    $access->update = tienePrivilegio($db, $sessionid, 12);
    $access->delete = tienePrivilegio($db, $sessionid, 13);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   0 = ID de la moneda DESCENDENTE (mas reciente)
    *   1 = Nombre de la moneda ASCENDENTE
    *   2 = Simbolo de la moneda ASCENDENTE
    *   3 = Status de la moneda ASCEDENTE
    *   -1 = Nombre de la moneda DESCENDENTE
    *   -2 = Simbolo de la moneda DESCENDENTE
    *   -3 = Status de la moneda DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = "id DESC";
                break;
            case 1:
                $orderres = "name ASC";
                break;
            case 2:
                $orderres = "symbol ASC";
                break;
            case 3:
                $orderres = "status ASC";
                break;
            case 4:
                $orderres = "id ASC";
                break;
            case -1:
                $orderres = "name DESC";
                break;
            case -2:
                $orderres = "symbol DESC";
                break;
            case -3:
                $orderres = "status DESC";
                break;
            case -4:
                $orderres = "id DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 1, 2, 3, 4, -1, -2, -3 o -4"));
                break;
        }
        
        return $orderres;
    }
?>
