<?php
// app/api/transactions/validation

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Validamos que exista el registro
    $sql = "SELECT id FROM transactions WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se encuentra el registro",
            "eng"=>"Cannot find the record"), $lang, "No se encuentra el registro")));
    }
    
    //Creamos el validador
    $validator = getValidator(8);
    
    //Actualizamos el validator
    $sql = "UPDATE transactions SET".
    "       validthru = DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       validator = ".$validator.
    "       WHERE txid = ".$id;
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error));
    }
    
    //Retornamos 304 si no se elimino ningun registro
    if ($db->affected_rows == 0){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se pudo modificar",
            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
    }
    
    $out->id = (int)$id;
    
    //Obtenemos el correo del usuario para envio de codigo
    $sql = "SELECT * FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $email = $userdata["usr"];
    $subject = "Codigo de retiro AFX";
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $body = "Hola ".strtolower($email).", para completar el retiro de fondos ingrese el codigo a continuacion:<br><br>".
            "<b>".$validator."</b><br><br>".
            "<b>Este c&oacute;digo expirar&aacute; en 10 minutos.</b><br><br>".
            "<br>Gracias de antemano<br>AFX<br>";
            
    enviarCorreo($fromeMail, strtolower($email), $subject, $body);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>