WS_waitscreen = true;

window.onload = function(){
    
    // Go back
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('step','depositFunds',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go step 4
    document.getElementById('next-button').addEventListener("click", function(){
        gotoPage('step','depositFundsFinal',{ 'sessionid' : getParameterByName('sessionid'), 'cid' : getParameterByName('cid'), 'idr' : getParameterByName('idr'), 'd' : getParameterByName('d') })
    });
    
    // Go back R
    document.getElementById('previous-buttonR').addEventListener("click", function(){
        gotoPage('step','depositFunds',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go step 4 R
    document.getElementById('next-buttonR').addEventListener("click", function(){
        gotoPage('step','depositFundsFinal',{ 'sessionid' : getParameterByName('sessionid'), 'cid' : getParameterByName('cid'), 'idr' : getParameterByName('idr'), 'd' : getParameterByName('d') })
    });
    
    // Step
    document.getElementById('floatButton').addEventListener("click",function(){
        var popup = document.getElementById("floatButton").children[0].children[0];
        if(popup.classList.contains('show')){
            gotoPage('dashboard','home',{ 'sessionid' : getParameterByName('sessionid') })
        }else{
            popup.classList.toggle("show");
        }
    })

    document.getElementById('floatClose').addEventListener("click",function(event){
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })
    
    // Session Update
    document.getElementById('expSessionButton').addEventListener("click",function(){
        var req = {
            'sessionid': getParameterByName('sessionid')
        }
        sessionUpdate(req)
    })
    
    // copyBtc
    document.getElementById('copyIconBtc').addEventListener("click", function(){
        document.getElementById('copyDepBTC').select();
        document.execCommand('copy');
    });
    
    // Go to preferences
    document.getElementById('preferences').addEventListener("click", function(){
        gotoPage('preferences','main',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to preferences
    document.getElementById('preferencesR').addEventListener("click", function(){
        gotoPage('preferences','main',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to balance
    document.getElementById('balance').addEventListener("click", function(){
        gotoPage('balance','balance',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to balance
    document.getElementById('balanceR').addEventListener("click", function(){
        gotoPage('balance','balance',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    document.getElementById('example-element-toggle2').checked = false;
    
    // Bar
    document.getElementById('togglebar').addEventListener("click", function(){
        var el = document.getElementById('addView2')
        document.getElementById('addView2').style.display = 'block'
        setTimeout(function(){ 
            document.getElementById('example-element-toggle2').checked = !document.getElementById('example-element-toggle2').checked;
        }, 15);   
        
    });
    
    // Logout
    document.getElementById('logouticon').addEventListener("click", function(){
        logout();
    });
    
    // Logout
    document.getElementById('logouticon2').addEventListener("click", function(){
        logout();
    });
    
    init()
    
    //Mostrar HTML cargado
    esconderHTML(false);
    
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"

    
}

function expiredSession(){
    document.getElementsByClassName('expired')[0].style.display = "table"
    WS_waitscreen = false;
    var seconds = 30;
    var countdown = setInterval(countDown, 1000);
    
    function countDown(){
        seconds--;
        if(seconds == 0){
            if(document.getElementsByClassName('expired')[0].style.display == "table"){
                gotoPage('login','main','');
                clearInterval(countdown);
            }
        }
        if(document.getElementsByClassName('expired')[0].style.display == "none"){
            clearInterval(countdown)
        }
    }
}

function sessionUpdate(req){
    callWS('GET', 'session/update', req, response);
    function response(status, rsp){
        console.log('session/update')
        console.log(JSON.parse(rsp));
        console.log(status) 
        switch(status){
            case 200:
                document.getElementsByClassName('expired')[0].style.display = "none";
                init()
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 402:
                break;
            case 403:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function init(){
    setLang()
}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                entrydata = (JSON.parse(rsp).entry)
                putName(entrydata);
                putInformationWalletBTC(getParameterByName('idr'))
                break;
            case 204:
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }    
}

function putName(entrydata){
    var name;
    if(entrydata.company){
        if(entrydata.company.name.value=="" || entrydata.company.name.value== null){
            name = entrydata.usr
        }else{
            name = entrydata.company.name.value
        }
    }
    else if(entrydata.person){
        if(entrydata.person.firstname.value=="" || entrydata.person.firstname.value==null){
            name = entrydata.usr
        }else{
            name = entrydata.person.firstname.value + ' '+ entrydata.person.firstlastname.value
        }
    }
    document.getElementById('name').innerHTML = name
    document.getElementById('name2').innerHTML = name
}

function logout(){
    var sessionid = getParameterByName('sessionid')
    var req ={
        'sessionid': sessionid,
    }
    callWS('GET', 'login/logout', req, response);

    function response(status, rsp){
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                gotoPage('login','main','')
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function putInformationWalletBTC(id){
    document.getElementById('copyDepBTC').value = ''
    accountsEntry(id)
}

// Service accounts/entry
function accountsEntry(id){
    
    var req ={
        'sessionid': getParameterByName('sessionid'),
        'id' : id
    }
    console.log(req)
    callWS('GET', 'accounts/entry', req, response);

    function response(status, rsp){
        console.log('Aqui accounts/entry')
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                document.getElementById('copyInfAFX').innerHTML = JSON.parse(rsp).entry.details1.value;
                document.getElementById('addressBTCInfDate').innerHTML = JSON.parse(rsp).entry.wallet.expiry.formatted;
                document.getElementById("qrcode").innerHTML=''
                var qrcode = new QRCode(document.getElementById("qrcode"), {
                    text: document.getElementById('copyInfAFX').innerHTML,
                    width: 110,
                    height: 110,
                    colorDark : "#000000",
                    colorLight : "#ffffff",
                    correctLevel : QRCode.CorrectLevel.H
                });
                document.getElementById('copyDepBTC').value = document.getElementById('copyInfAFX').innerHTML
                req = {
                    'sessionid': getParameterByName('sessionid'),
                    'currencyid': getParameterByName('cid'),
                }
                feesEntry(req); 
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

// fees/entry
var decimCoin = 0;
function feesEntry(req){
    console.log(req)
    callWS('GET', 'fees/entry', req, response);
    function response(status, rsp){
        console.log('fees/entry')
        console.log(JSON.parse(rsp));
        console.log(status) 
        switch(status){
            case 200:
                if(JSON.parse(rsp).entry.deposits.nmalfee){
                    document.getElementById("depositCriptoFee").innerHTML = number_format(JSON.parse(rsp).entry.deposits.nmalfee.number,getParameterByName('d'));
                }
                else if(JSON.parse(rsp).entry.deposits.pctfee){
                    document.getElementById('depositCriptoFee').innerHTML = (JSON.parse(rsp).entry.deposits.pctfee.formatted) + '%';
                }else{
                    document.getElementById('depositCriptoFee').innerHTML = 'N/A';
                }
                break;
            case 400:
                document.getElementsByClassName('failure')[0].style.display = "table"
                break;
            case 401:
                expiredSession();
                break;
            default:
                document.getElementsByClassName('failure')[0].style.display = "table"
                break;
        }
    }   
}

function setLang(){
    
    lang = localStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('home','home');
    setWordLanginnerHTML('balance','balance');
    setWordLanginnerHTML('preferences','preferences');
    setWordLanginnerHTML('homeR','home');
    setWordLanginnerHTML('balanceR','balance');
    setWordLanginnerHTML('preferencesR','preferences');
    setWordLanginnerHTML('langIcon','langIcon');
    
    setWordLanginnerHTML('titlePage','titlePage');
    setWordLanginnerHTML('step1','step1');
    setWordLanginnerHTML('step2','step2');
    setWordLanginnerHTML('step3','step3');
    setWordLanginnerHTML('step4','step4');
    setWordLanginnerHTML('step5','step5');
    
    setWordLanginnerHTML('t1','t1');
    setWordLanginnerHTML('t2','t2');
    
    
    setWordLanginnerHTML('expirationLabel','expiration');
    setWordLanginnerHTML('feesLabel','FEES');
    setWordLanginnerHTML('t3','t3');
    
    
    
    setWordLanginnerHTML('previous-button','RETURN');
    setWordLanginnerHTML('next-button','continue');
    setWordLanginnerHTML('previous-buttonR','RETURN');
    setWordLanginnerHTML('next-buttonR','continue');
    
    
    setWordLanginnerHTML('buttonAdv','ADVANCEDMODE');
    setWordLanginnerHTML('question','question');
    setWordLanginnerHTML('expired1','expired1');
    setWordLanginnerHTML('expired2','expired2');
    setWordLanginnerHTML('expSessionButton','continue');
    setWordLanginnerHTML('ts','ts');

    
    document.getElementById('floatClose').addEventListener("click",function(event){
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })
    
    getEntry(getParameterByName('sessionid'));

}